/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap.mixin;

import java.util.Map;
import net.forixaim.ex_cap.capabilities.weaponcaps.RangedWeapon;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

@Mixin(value={ProjectilePatch.class})
public abstract class MixinProjectilePatch {
    @Shadow(remap=false)
    protected float armorNegation;
    @Shadow(remap=false)
    protected Vec3 initialFirePosition;
    @Shadow(remap=false)
    protected float impact;

    @Shadow(remap=false)
    protected abstract void setMaxStrikes(Projectile var1, int var2);

    @Inject(method={"onJoinWorld(Lnet/minecraft/world/entity/projectile/Projectile;Lnet/minecraftforge/event/entity/EntityJoinLevelEvent;)V"}, at={@At(value="RETURN")}, remap=false)
    public void onJoinWorld(Projectile projectileEntity, EntityJoinLevelEvent event, CallbackInfo ci) {
        Entity shooter = projectileEntity.m_19749_();
        boolean flag = true;
        if (shooter instanceof LivingEntity) {
            LivingEntity livingshooter = (LivingEntity)shooter;
            this.initialFirePosition = shooter.m_20182_();
            ItemStack heldItem = livingshooter.m_21205_();
            CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability((ItemStack)heldItem);
            if (itemCap instanceof RangedWeapon) {
                Map modifierMap = itemCap.getDamageAttributesInCondition((Style)CapabilityItem.Styles.RANGED);
                if (modifierMap != null) {
                    this.armorNegation = modifierMap.containsKey(EpicFightAttributes.ARMOR_NEGATION.get()) ? (float)((AttributeModifier)modifierMap.get(EpicFightAttributes.ARMOR_NEGATION.get())).m_22218_() : (float)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22082_();
                    float f = this.impact = modifierMap.containsKey(EpicFightAttributes.IMPACT.get()) ? (float)((AttributeModifier)modifierMap.get(EpicFightAttributes.IMPACT.get())).m_22218_() : (float)((Attribute)EpicFightAttributes.IMPACT.get()).m_22082_();
                    if (modifierMap.containsKey(EpicFightAttributes.MAX_STRIKES.get())) {
                        this.setMaxStrikes(projectileEntity, (int)((AttributeModifier)modifierMap.get(EpicFightAttributes.MAX_STRIKES.get())).m_22218_());
                    }
                }
                flag = false;
            }
        }
        if (flag) {
            this.armorNegation = 0.0f;
            this.impact = 0.0f;
        }
    }
}

