/*
 * Decompiled with CFR 0.152.
 */
package github.meloweh.wolfcompanion.mixin;

import github.meloweh.wolfcompanion.accessor.ServerPlayerAccessor;
import github.meloweh.wolfcompanion.util.NBTHelper;
import github.meloweh.wolfcompanion.util.WolfNbtList;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
implements ServerPlayerAccessor {
    @Unique
    class_3222 self;
    @Unique
    WolfNbtList rescuedWolfNbtList = new WolfNbtList();
    @Unique
    WolfNbtList whistleWolfNbtList = new WolfNbtList();

    @Override
    @Accessor(value="field_13995")
    public abstract MinecraftServer getServer__();

    @Accessor(value="field_13986")
    public abstract int getScreenHandlerSyncId();

    @Invoker(value="method_14237")
    public abstract void execIncrementScreenHandlerSyncId();

    @Invoker(value="method_14235")
    public abstract void execOnScreenHandlerOpened(class_1703 var1);

    @Override
    public WolfNbtList getRescuedWolfNbts__() {
        return this.rescuedWolfNbtList;
    }

    @Override
    public WolfNbtList getWhistleWolfNbts__() {
        return this.whistleWolfNbtList;
    }

    @Inject(method={"method_14203(Lnet/minecraft/class_3222;Z)V"}, at={@At(value="TAIL")})
    private void restorePlayerDataAfterRespawn(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        this.rescuedWolfNbtList = ((ServerPlayerAccessor)oldPlayer).getRescuedWolfNbts__();
        this.whistleWolfNbtList = ((ServerPlayerAccessor)oldPlayer).getWhistleWolfNbts__();
    }

    @Inject(method={"method_34225()V"}, at={@At(value="TAIL")})
    private void spawnDoggosOnSpawn(CallbackInfo ci) {
        this.respawnRescuedDoggo(null, null);
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    public void writeWolfDataToNbt(class_11372 view, CallbackInfo ci) {
        this.rescuedWolfNbtList.writeDataToNbt(view, "SavedWolfData");
        this.whistleWolfNbtList.writeDataToNbt(view, "WhistleWolfData");
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    public void readWolfDataToNbt(class_11368 view, CallbackInfo ci) {
        this.rescuedWolfNbtList.readDataToNbt(view, "SavedWolfData");
        this.whistleWolfNbtList.readDataToNbt(view, "WhistleWolfData");
    }

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3218;Lcom/mojang/authlib/GameProfile;Lnet/minecraft/class_8791;)V"}, at={@At(value="RETURN")})
    private void onConstructor(CallbackInfo info) {
        this.self = (class_3222)this;
    }

    @Unique
    private void spawnDoggos(WolfNbtList wolfNbtList, boolean rescue) {
        WolfNbtList canDelete = new WolfNbtList();
        wolfNbtList.getWolfNbts().forEach(wolfNbt -> {
            boolean success;
            if (rescue) {
                NBTHelper.cleanRescueWolfNbt(wolfNbt, this.self.method_6063());
            }
            if (success = NBTHelper.spawnWolfFromNbt(this.self, wolfNbt, rescue)) {
                canDelete.queueWolfNbt((class_2487)wolfNbt);
            }
        });
        wolfNbtList.getWolfNbts().removeIf(wolfNbt -> canDelete.getWolfNbts().contains(wolfNbt));
    }

    @Inject(method={"method_18403(Lnet/minecraft/class_2338;)V"}, at={@At(value="TAIL")})
    private void respawnRescuedDoggo(class_2338 pos, CallbackInfo ci) {
        if (this.self.method_6113()) {
            this.spawnDoggos(this.rescuedWolfNbtList, true);
        }
    }

    @Override
    public void queueRescuedWolfNbt__(class_2487 nbt) {
        this.rescuedWolfNbtList.queueWolfNbt(nbt);
    }

    @Override
    public void queueWhistleWolfNbt__(class_2487 nbt) {
        this.whistleWolfNbtList.queueWolfNbt(nbt);
    }

    @Override
    public void spawnWhistleWolfNbts__() {
        this.spawnDoggos(this.whistleWolfNbtList, false);
    }
}

