/*
 * Decompiled with CFR 0.152.
 */
package github.meloweh.wolfcompanion.screenhandler;

import github.meloweh.wolfcompanion.accessor.WolfEntityMixinProvider;
import github.meloweh.wolfcompanion.accessor.WolfEntityProvider;
import github.meloweh.wolfcompanion.init.ScreenHandlerTypeInit;
import github.meloweh.wolfcompanion.network.UuidPayload;
import github.meloweh.wolfcompanion.shadow.ShadowArmorSlot;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11565;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_3914;

public class WolfInventoryScreenHandler
extends class_1703 {
    private final class_1493 wolf;
    private final class_3914 context;
    private final class_1277 wolfInventory;
    private class_1735 armorSlot;
    private static final int WOLF_SLOTS = 16;

    private static class_1493 getWolfEntity(class_1661 playerInventory, UuidPayload payload) {
        class_1657 player = playerInventory.field_7546;
        class_238 area = new class_238(player.method_23317() + -20.0, player.method_23318() + -20.0, player.method_23321() + -20.0, player.method_23317() + 20.0, player.method_23318() + 20.0, player.method_23321() + 20.0);
        List entities = playerInventory.field_7546.method_73183().method_8335((class_1297)playerInventory.field_7546, area);
        List<class_1493> wolfes = entities.stream().filter(e -> e instanceof class_1493).map(e -> (class_1493)e).toList();
        Optional<class_1493> optWolf = wolfes.stream().filter(e -> e.method_5667().equals(payload.uuid())).findFirst();
        if (optWolf.isEmpty()) {
            throw new IllegalStateException("Client does not have wolf.");
        }
        return optWolf.get();
    }

    public WolfInventoryScreenHandler(int syncId, class_1661 playerInventory, UuidPayload payload) {
        this(syncId, playerInventory, WolfInventoryScreenHandler.getWolfEntity(playerInventory, payload), payload.nbt());
    }

    public class_1493 getWolf() {
        return this.wolf;
    }

    public class_1277 getWolfInventory() {
        return this.wolfInventory;
    }

    public WolfInventoryScreenHandler(int syncId, class_1661 playerInventory, class_1493 wolf, class_2487 nbt) {
        super(ScreenHandlerTypeInit.WOLF_INVENTORY_SCREEN_HANDLER, syncId);
        this.wolf = wolf;
        this.context = class_3914.method_17392((class_1937)this.wolf.method_73183(), null);
        this.wolfInventory = ((WolfEntityMixinProvider)wolf).wolfcompanion_template_1_21_1$getItemsInventory();
        WolfInventoryScreenHandler.method_17359((class_1263)this.wolfInventory, (int)16);
        this.wolfInventory.method_5435((class_11565)playerInventory.field_7546);
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.addWolfInventory(this.wolfInventory);
    }

    private void addPlayerInventory(class_1661 playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new class_1735((class_1263)playerInv, 9 + (column + row * 9), 8 + column * 18, 84 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 playerInv) {
        for (int column = 0; column < 9; ++column) {
            this.method_7621(new class_1735((class_1263)playerInv, column, 8 + column * 18, 142));
        }
    }

    private void addWolfInventory(class_1277 inventory) {
        this.armorSlot = this.method_7621(new ShadowArmorSlot((class_1263)inventory, (class_1309)this.wolf, class_1304.field_48824, 0, 8, 18, null));
        class_1799 armorStack = this.wolf.method_6118(class_1304.field_48824);
        this.armorSlot.method_53512(armorStack);
        if (((WolfEntityProvider)this.wolf).hasChestEquipped()) {
            for (int k = 0; k < 3; ++k) {
                for (int l = 0; l < 5; ++l) {
                    this.method_7621(new class_1735((class_1263)inventory, 1 + l + k * 5, 80 + l * 18, 18 + k * 18));
                }
            }
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        for (int k = 0; k < this.field_7761.size(); ++k) {
            class_1735 slot = this.method_7611(k);
            class_1799 stack = slot.method_7677();
            if (!stack.method_7960()) continue;
        }
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = this.method_7611(slotIndex);
        if (slot != null && slot.method_7681()) {
            class_1799 inSlot = slot.method_7677();
            newStack = inSlot.method_7972();
            if (slotIndex < 16 ? !this.method_7616(inSlot, 16, this.field_7761.size(), true) : !this.method_7616(inSlot, 0, 16, false)) {
                return class_1799.field_8037;
            }
            if (inSlot.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        super.method_7593(slotIndex, button, actionType, player);
        if (!this.armorSlot.method_7677().method_7960() && !this.wolf.method_56677()) {
            this.wolf.method_56678(this.armorSlot.method_7677());
        }
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }
}

