/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.commands;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CustomEnchantsCommand
implements CommandExecutor,
TabCompleter {
    private final CustomEnchants plugin;

    public CustomEnchantsCommand(CustomEnchants plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "list": {
                this.listEnchantments(sender);
                break;
            }
            case "give": {
                if (args.length < 4) {
                    sender.sendMessage("\u00a7cUsage: /" + label + " give <player> <enchant> <level>");
                    return true;
                }
                this.giveEnchantedBook(sender, args[1], args[2], args[3]);
                break;
            }
            case "test": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cThis command can only be used by players!");
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /" + label + " test <enchant> <level>");
                    return true;
                }
                this.testEnchantment((Player)sender, args[1], args[2]);
                break;
            }
            case "rolltable": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cThis command can only be used by players!");
                    return true;
                }
                this.simulateEnchantmentTable((Player)sender);
                break;
            }
            case "reload": {
                if (!sender.hasPermission("customenchants.reload")) {
                    sender.sendMessage("\u00a7cYou don't have permission to reload the plugin!");
                    return true;
                }
                this.reloadPlugin(sender);
                break;
            }
            case "books": {
                if (sender instanceof Player) {
                    sender.sendMessage("\u00a7eCustom enchants GUI coming soon! Stay tuned.");
                }
                return true;
            }
            default: {
                this.showHelp(sender);
            }
        }
        return true;
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== Custom Enchants Help ===");
        sender.sendMessage("\u00a7e/customenchants list \u00a77- List all custom enchantments");
        sender.sendMessage("\u00a7e/ce give <player> <enchant> <level> \u00a77- Give enchanted book");
        sender.sendMessage("\u00a7e/ce test <enchant> <level> \u00a77- Apply enchant directly to held item");
        sender.sendMessage("\u00a7e/ce rolltable \u00a77- Simulate enchantment table logic");
        sender.sendMessage("\u00a7e/customenchants reload \u00a77- Reload plugin configuration");
        sender.sendMessage("\u00a7e/customenchants books \u00a77- All of the books in a gui");
        sender.sendMessage("\u00a7e/customenchants help \u00a77- Show this help message");
        sender.sendMessage("");
        sender.sendMessage("\u00a77Available enchantments: \u00a7flifesteal, explode, poison_blade, freeze, blinding, lightning_strike, berserker, explosive_arrow, thorns_aura");
    }

    private void listEnchantments(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== Custom Enchantments ===");
        Map<String, CustomEnchant> enchantments = this.plugin.getEnchantmentManager().getAllEnchantments();
        for (CustomEnchant enchant : enchantments.values()) {
            String rarityColor = this.getRarityColor(enchant.getRarity());
            String enabledStatus = enchant.isEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled";
            sender.sendMessage("\u00a7e" + enchant.getDisplayName() + " \u00a77(" + rarityColor + enchant.getRarity().name() + "\u00a77) - " + enabledStatus);
            sender.sendMessage("  \u00a77" + enchant.getDescription());
            sender.sendMessage("  \u00a77Max Level: \u00a7f" + enchant.getMaxLevel());
            sender.sendMessage("");
        }
    }

    private void giveEnchantedBook(CommandSender sender, String playerName, String enchantKey, String levelStr) {
        int level;
        if (!sender.hasPermission("customenchants.give")) {
            sender.sendMessage("\u00a7cYou don't have permission to give enchanted books!");
            return;
        }
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found: " + playerName);
            return;
        }
        CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
        if (enchant == null) {
            sender.sendMessage("\u00a7cUnknown enchantment: " + enchantKey);
            return;
        }
        try {
            level = Integer.parseInt(levelStr);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid level: " + levelStr);
            return;
        }
        if (level < 1 || level > enchant.getMaxLevel()) {
            sender.sendMessage("\u00a7cLevel must be between 1 and " + enchant.getMaxLevel());
            return;
        }
        ItemStack book = this.plugin.getEnchantmentManager().createEnchantedBook(enchantKey, level);
        if (book == null) {
            sender.sendMessage("\u00a7cFailed to create enchanted book!");
            return;
        }
        if (target.getInventory().firstEmpty() == -1) {
            target.getWorld().dropItem(target.getLocation(), book);
            target.sendMessage("\u00a77Your inventory was full, so the enchanted book was dropped!");
        } else {
            target.getInventory().addItem(new ItemStack[]{book});
        }
        String rarityColor = this.getRarityColor(enchant.getRarity());
        sender.sendMessage("\u00a7aGave " + target.getName() + " a " + rarityColor + enchant.getDisplayName() + " " + level + " \u00a7aenchanted book!");
        target.sendMessage("\u00a7aYou received a " + rarityColor + enchant.getDisplayName() + " " + level + " \u00a7aenchanted book!");
    }

    private void testEnchantment(Player player, String enchantKey, String levelStr) {
        int level;
        if (!player.hasPermission("customenchants.test")) {
            player.sendMessage("\u00a7cYou don't have permission to test enchantments!");
            return;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (heldItem == null || heldItem.getType() == Material.AIR) {
            player.sendMessage("\u00a7cYou must be holding an item to test enchantments!");
            return;
        }
        CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
        if (enchant == null) {
            player.sendMessage("\u00a7cUnknown enchantment: " + enchantKey);
            return;
        }
        try {
            level = Integer.parseInt(levelStr);
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7cInvalid level: " + levelStr);
            return;
        }
        if (level < 1 || level > enchant.getMaxLevel()) {
            player.sendMessage("\u00a7cLevel must be between 1 and " + enchant.getMaxLevel());
            return;
        }
        boolean success = this.plugin.getEnchantmentManager().applyEnchantment(heldItem, enchantKey, level);
        if (success) {
            String rarityColor = this.getRarityColor(enchant.getRarity());
            player.sendMessage("\u00a7aApplied " + rarityColor + enchant.getDisplayName() + " " + level + " \u00a7ato your " + heldItem.getType().name().toLowerCase().replace("_", " ") + "!");
        } else {
            player.sendMessage("\u00a7cFailed to apply enchantment! The item may not be compatible with this enchantment.");
        }
    }

    private void simulateEnchantmentTable(Player player) {
        if (!player.hasPermission("customenchants.rolltable")) {
            player.sendMessage("\u00a7cYou don't have permission to simulate enchantment tables!");
            return;
        }
        player.sendMessage("\u00a76\u00a7l=== Enchantment Table Simulation ===");
        player.sendMessage("\u00a77Rolling for 3 random enchantments...");
        player.sendMessage("");
        Map<String, CustomEnchant> enchantments = this.plugin.getEnchantmentManager().getAllEnchantments();
        ArrayList<CustomEnchant> enabledEnchants = new ArrayList<CustomEnchant>();
        for (CustomEnchant enchant : enchantments.values()) {
            if (!enchant.isEnabled()) continue;
            enabledEnchants.add(enchant);
        }
        if (enabledEnchants.isEmpty()) {
            player.sendMessage("\u00a7cNo enabled enchantments found!");
            return;
        }
        Random random = new Random();
        for (int i = 1; i <= 3; ++i) {
            CustomEnchant randomEnchant = (CustomEnchant)enabledEnchants.get(random.nextInt(enabledEnchants.size()));
            int randomLevel = random.nextInt(randomEnchant.getMaxLevel()) + 1;
            int cost = this.calculateEnchantmentCost(randomEnchant.getRarity(), randomLevel);
            String rarityColor = this.getRarityColor(randomEnchant.getRarity());
            player.sendMessage("\u00a7e" + i + ". " + rarityColor + randomEnchant.getDisplayName() + " " + randomLevel + " \u00a77- Cost: \u00a7a" + cost + " levels");
        }
        player.sendMessage("");
        player.sendMessage("\u00a77This is just a simulation! No items were enchanted.");
    }

    private int calculateEnchantmentCost(EnchantRarity rarity, int level) {
        return (switch (rarity) {
            case EnchantRarity.COMMON -> 5;
            case EnchantRarity.RARE -> 15;
            case EnchantRarity.EPIC -> 25;
            case EnchantRarity.LEGENDARY -> 35;
            default -> 10;
        }) + level * 3;
    }

    private void reloadPlugin(CommandSender sender) {
        this.plugin.getConfigManager().reloadConfig();
        this.plugin.getEnchantmentManager().reloadEnchantments();
        sender.sendMessage("\u00a7aCustom Enchants configuration and enchantments reloaded!");
    }

    private String getRarityColor(EnchantRarity rarity) {
        switch (rarity) {
            case COMMON: {
                return "\u00a7f";
            }
            case RARE: {
                return "\u00a79";
            }
            case EPIC: {
                return "\u00a7d";
            }
            case LEGENDARY: {
                return "\u00a76";
            }
        }
        return "\u00a77";
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block8: {
            block11: {
                block10: {
                    block9: {
                        block7: {
                            completions = new ArrayList<String>();
                            if (args.length != 1) break block7;
                            completions.addAll(Arrays.asList("list", "give", "test", "rolltable", "reload", "help"));
                            break block8;
                        }
                        if (args.length != 2 || !args[0].equalsIgnoreCase("give")) break block9;
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            completions.add(player.getName());
                        }
                        break block8;
                    }
                    if (args.length != 3 || !args[0].equalsIgnoreCase("give")) break block10;
                    completions.addAll(this.plugin.getEnchantmentManager().getEnchantmentKeys());
                    break block8;
                }
                if (args.length != 4 || !args[0].equalsIgnoreCase("give")) break block11;
                String enchantKey = args[2];
                CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
                if (enchant == null) break block8;
                for (int i = 1; i <= enchant.getMaxLevel(); ++i) {
                    completions.add(String.valueOf(i));
                }
                break block8;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("test")) {
                completions.addAll(this.plugin.getEnchantmentManager().getEnchantmentKeys());
            } else if (args.length == 3 && args[0].equalsIgnoreCase("test")) {
                String enchantKey = args[1];
                CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
                if (enchant != null) {
                    for (int i = 1; i <= enchant.getMaxLevel(); ++i) {
                        completions.add(String.valueOf(i));
                    }
                }
            }
        }
        return completions;
    }
}

