/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BlindingEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "blinding";
    }

    @Override
    public String getDisplayName() {
        return "Blinding";
    }

    @Override
    public String getDescription() {
        return "Blinds your target temporarily";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.LEGENDARY;
    }

    @Override
    public int getMaxLevel() {
        return 2;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        int baseDuration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.blinding.base-duration-ticks", 60);
        int durationPerLevel = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.blinding.duration-per-level-ticks", 40);
        int totalDuration = baseDuration + durationPerLevel * level;
        PotionEffect blindnessEffect = new PotionEffect(PotionEffectType.BLINDNESS, totalDuration, 0, false, true);
        target.addPotionEffect(blindnessEffect);
        if (level >= 2) {
            PotionEffect nauseaEffect = new PotionEffect(PotionEffectType.NAUSEA, totalDuration / 2, 0, false, true);
            target.addPotionEffect(nauseaEffect);
        }
        target.getWorld().spawnParticle(Particle.LARGE_SMOKE, target.getLocation().add(0.0, 1.5, 0.0), 20, 0.3, 0.3, 0.3, 0.1);
        target.getWorld().spawnParticle(Particle.WITCH, target.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 0.5, 0.5, 0.1);
        target.getWorld().playSound(target.getLocation(), Sound.ENTITY_GHAST_SCREAM, 0.5f, 2.0f);
        String blindLevel = level == 1 ? "blinded" : "completely disoriented";
        attacker.sendMessage("\u00a78\u26ab \u00a77Target has been \u00a78" + blindLevel + "\u00a77!");
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.blinding.enabled", true);
    }
}

