/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BloodthirstEnchant
extends CustomEnchant {
    private Map<UUID, Double> recentDamage = new HashMap<UUID, Double>();
    private Map<UUID, BukkitRunnable> healingTasks = new HashMap<UUID, BukkitRunnable>();

    @Override
    public String getKey() {
        return "bloodthirst";
    }

    @Override
    public String getDisplayName() {
        return "Bloodthirst";
    }

    @Override
    public String getDescription() {
        return "Regenerates health faster based on damage dealt in the last few seconds";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.LEGENDARY;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(final Player attacker, LivingEntity target, final int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        if (target.getLastDamageCause() instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent event = (EntityDamageByEntityEvent)target.getLastDamageCause();
            double damage = event.getFinalDamage();
            final UUID playerId = attacker.getUniqueId();
            this.recentDamage.put(playerId, this.recentDamage.getOrDefault(playerId, 0.0) + damage);
            if (this.healingTasks.containsKey(playerId)) {
                this.healingTasks.get(playerId).cancel();
            }
            BukkitRunnable healingTask = new BukkitRunnable(this){
                private int ticks = 0;
                private final int maxTicks = 60;
                final /* synthetic */ BloodthirstEnchant this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    if (!attacker.isOnline() || this.ticks >= 60) {
                        this.this$0.recentDamage.remove(playerId);
                        this.this$0.healingTasks.remove(playerId);
                        this.cancel();
                        return;
                    }
                    double totalDamage = this.this$0.recentDamage.getOrDefault(playerId, 0.0);
                    if (totalDamage > 0.0) {
                        double healMultiplier = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.bloodthirst.heal-multiplier-per-level", 0.05);
                        double healAmount = totalDamage * healMultiplier * (double)level / 60.0;
                        double currentHealth = attacker.getHealth();
                        double maxHealth = attacker.getMaxHealth();
                        double newHealth = Math.min(currentHealth + healAmount, maxHealth);
                        attacker.setHealth(newHealth);
                        if (this.ticks % 20 == 0) {
                            attacker.sendMessage("\u00a74\ud83e\ude78 \u00a77Bloodthirst regenerating health...");
                        }
                    }
                    ++this.ticks;
                }
            };
            healingTask.runTaskTimer((Plugin)CustomEnchants.getInstance(), 0L, 1L);
            this.healingTasks.put(playerId, healingTask);
        }
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.bloodthirst.enabled", true);
    }
}

