/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BulwarkEnchant
extends CustomEnchant {
    private final Map<UUID, Long> lastActivation = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> shieldActive = new HashMap<UUID, Boolean>();

    @Override
    public String getKey() {
        return "bulwark";
    }

    @Override
    public String getDisplayName() {
        return "Bulwark";
    }

    @Override
    public String getDescription() {
        return "Every 10 seconds, automatically blocks the next incoming damage completely";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.LEGENDARY;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
        long currentTime;
        if (!this.isEnabled()) {
            return;
        }
        UUID playerId = player.getUniqueId();
        if (!this.isShieldReady(playerId, currentTime = System.currentTimeMillis(), level)) {
            return;
        }
        event.setCancelled(true);
        this.lastActivation.put(playerId, currentTime);
        this.shieldActive.put(playerId, false);
        player.getWorld().spawnParticle(Particle.FIREWORK, player.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 0.5, 0.5, 0.1);
        player.getWorld().spawnParticle(Particle.ENCHANT, player.getLocation(), 20, 1.0, 1.0, 1.0, 0.5);
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 2.0f);
        player.sendMessage("\u00a76\u26a1 \u00a77Bulwark absorbed the damage!");
        this.scheduleShieldRecharge(player, level);
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    private boolean isShieldReady(UUID playerId, long currentTime, int level) {
        int cooldownSeconds;
        if (!this.lastActivation.containsKey(playerId)) {
            this.shieldActive.put(playerId, true);
            return true;
        }
        long timeSinceLastUse = currentTime - this.lastActivation.get(playerId);
        if (timeSinceLastUse >= (long)(cooldownSeconds = this.getShieldCooldown(level)) * 1000L) {
            this.shieldActive.put(playerId, true);
            return true;
        }
        return this.shieldActive.getOrDefault(playerId, false);
    }

    private int getShieldCooldown(int level) {
        int baseCooldown = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.bulwark.base-cooldown", 10);
        int cooldownReduction = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.bulwark.cooldown-reduction-per-level", 1);
        return Math.max(5, baseCooldown - cooldownReduction * (level - 1));
    }

    private void scheduleShieldRecharge(final Player player, int level) {
        int cooldownSeconds = this.getShieldCooldown(level);
        final UUID playerId = player.getUniqueId();
        new BukkitRunnable(this){
            final /* synthetic */ BulwarkEnchant this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (player.isOnline()) {
                    this.this$0.shieldActive.put(playerId, true);
                    player.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, player.getLocation().add(0.0, 2.0, 0.0), 10, 0.3, 0.3, 0.3, 0.1);
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 0.5f, 1.5f);
                    player.sendMessage("\u00a76\u26a1 \u00a77Bulwark shield recharged!");
                }
            }
        }.runTaskLater((Plugin)CustomEnchants.getInstance(), (long)cooldownSeconds * 20L);
        if (cooldownSeconds > 5) {
            new BukkitRunnable(this){

                public void run() {
                    if (player.isOnline()) {
                        player.sendMessage("\u00a77Bulwark recharging in 5 seconds...");
                    }
                }
            }.runTaskLater((Plugin)CustomEnchants.getInstance(), (long)(cooldownSeconds - 5) * 20L);
        }
    }

    public void startShieldIndicator(final Player player, int level) {
        final UUID playerId = player.getUniqueId();
        new BukkitRunnable(this){
            final /* synthetic */ BulwarkEnchant this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline() || !this.this$0.shieldActive.getOrDefault(playerId, false).booleanValue()) {
                    this.cancel();
                    return;
                }
                player.getWorld().spawnParticle(Particle.ENCHANT, player.getLocation().add(0.0, 0.1, 0.0), 3, 0.3, 0.1, 0.3, 0.1);
            }
        }.runTaskTimer((Plugin)CustomEnchants.getInstance(), 0L, 40L);
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.bulwark.enabled", true);
    }
}

