/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CureTouchEnchant
extends CustomEnchant {
    private static final List<PotionEffectType> NEGATIVES = Arrays.asList(PotionEffectType.POISON, PotionEffectType.WITHER, PotionEffectType.BLINDNESS, PotionEffectType.WEAKNESS, PotionEffectType.SLOWNESS, PotionEffectType.NAUSEA);

    @Override
    public String getKey() {
        return "cure_touch";
    }

    @Override
    public String getDisplayName() {
        return "Cure Touch";
    }

    @Override
    public String getDescription() {
        return "Automatically cures negative effects.";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.LEGENDARY;
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
        if (!this.isEnabled()) {
            return;
        }
        for (PotionEffect effect : player.getActivePotionEffects()) {
            if (!NEGATIVES.contains(effect.getType())) continue;
            player.removePotionEffect(effect.getType());
        }
        player.sendMessage("\u00a7a\u2727 Your armor cleansed you of harmful effects!");
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.cure_touch.enabled", true);
    }
}

