/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.Random;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DisarmEnchant
extends CustomEnchant {
    private Random random = new Random();

    @Override
    public String getKey() {
        return "disarm";
    }

    @Override
    public String getDisplayName() {
        return "Disarm";
    }

    @Override
    public String getDescription() {
        return "Chance to make enemy drop their weapon for a moment";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.MYTHIC;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        PlayerInventory inv;
        ItemStack mainHand;
        if (!this.isEnabled() || !(target instanceof Player)) {
            return;
        }
        final Player targetPlayer = (Player)target;
        double chancePerLevel = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.disarm.chance-per-level", 0.1);
        double chance = chancePerLevel * (double)level;
        if (this.random.nextDouble() < chance && (mainHand = (inv = targetPlayer.getInventory()).getItemInMainHand()) != null && !mainHand.getType().isAir()) {
            final ItemStack weaponCopy = mainHand.clone();
            inv.setItemInMainHand(null);
            targetPlayer.sendMessage("\u00a7c\u2694 \u00a77You have been disarmed!");
            attacker.sendMessage("\u00a76\u2694 \u00a77Successfully disarmed your opponent!");
            int disarmDuration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.disarm.duration-ticks", 60);
            new BukkitRunnable(this){

                public void run() {
                    if (targetPlayer.isOnline()) {
                        targetPlayer.getInventory().setItemInMainHand(weaponCopy);
                        targetPlayer.sendMessage("\u00a7a\u2694 \u00a77Your weapon has been returned!");
                    }
                }
            }.runTaskLater((Plugin)CustomEnchants.getInstance(), (long)disarmDuration);
        }
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.disarm.enabled", true);
    }
}

