/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EmberWardEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "ember_ward";
    }

    @Override
    public String getDisplayName() {
        return "Ember Ward";
    }

    @Override
    public String getDescription() {
        return "Fire and lava damage heals you for 50-150% of the damage instead";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.EPIC;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
        if (!this.isEnabled()) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cause == EntityDamageEvent.DamageCause.FIRE || cause == EntityDamageEvent.DamageCause.FIRE_TICK || cause == EntityDamageEvent.DamageCause.LAVA || cause == EntityDamageEvent.DamageCause.HOT_FLOOR) {
            double originalDamage = event.getDamage();
            event.setCancelled(true);
            double baseHealingPercent = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.ember_ward.base-healing-percent", 0.5);
            double healingPerLevel = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.ember_ward.healing-per-level", 0.5);
            double healingPercent = baseHealingPercent + healingPerLevel * (double)(level - 1);
            double healingAmount = originalDamage * healingPercent;
            double currentHealth = player.getHealth();
            double maxHealth = player.getMaxHealth();
            double newHealth = Math.min(maxHealth, currentHealth + healingAmount);
            player.setHealth(newHealth);
            player.getWorld().spawnParticle(Particle.HEART, player.getLocation().add(0.0, 1.0, 0.0), (int)(healingAmount * 2.0), 0.5, 0.5, 0.5, 0.1);
            player.getWorld().spawnParticle(Particle.FLAME, player.getLocation(), 15, 0.3, 0.5, 0.3, 0.05);
            player.getWorld().spawnParticle(Particle.ENCHANT, player.getLocation().add(0.0, 0.5, 0.0), 10, 0.4, 0.4, 0.4, 0.3);
            player.playSound(player.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 0.5f, 1.5f);
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.3f, 2.0f);
            String healingMessage = String.format("\u00a7c\ud83d\udd25 \u00a77Ember Ward healed \u00a7a%.1f \u00a77hearts!", healingAmount / 2.0);
            player.sendMessage(healingMessage);
            if (level >= 3 && healingAmount >= 4.0) {
                player.getWorld().spawnParticle(Particle.FIREWORK, player.getLocation().add(0.0, 1.0, 0.0), 8, 0.3, 0.3, 0.3, 0.1);
                player.sendMessage("\u00a76\u2726 \u00a77Enhanced Ember Ward regeneration!");
            }
            if (cause == EntityDamageEvent.DamageCause.FIRE_TICK) {
                this.maintainFireEffect(player);
            }
        }
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    private void maintainFireEffect(final Player player) {
        BukkitRunnable fireEffect = new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (!player.isOnline() || this.ticks >= 20) {
                    this.cancel();
                    return;
                }
                if (this.ticks % 4 == 0) {
                    player.getWorld().spawnParticle(Particle.FLAME, player.getLocation().add(0.0, 0.1, 0.0), 2, 0.2, 0.1, 0.2, 0.01);
                }
                ++this.ticks;
            }
        };
        fireEffect.runTaskTimer((Plugin)CustomEnchants.getInstance(), 0L, 1L);
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.ember_ward.enabled", true);
    }
}

