/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ExplodeEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "explode";
    }

    @Override
    public String getDisplayName() {
        return "Explode";
    }

    @Override
    public String getDescription() {
        return "Creates a small explosion on hit";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.RARE;
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        Location targetLoc = target.getLocation();
        float explosionPower = (float)CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.explode.power-per-level", 0.5) * (float)level;
        boolean breakBlocks = CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.explode.break-blocks", false);
        targetLoc.getWorld().createExplosion(targetLoc, explosionPower, false, breakBlocks);
        targetLoc.getWorld().spawnParticle(Particle.EXPLOSION, targetLoc, 1);
        targetLoc.getWorld().playSound(targetLoc, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        double bonusDamage = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.explode.bonus-damage-per-level", 1.0) * (double)level;
        if (bonusDamage > 0.0) {
            target.damage(bonusDamage, (Entity)attacker);
        }
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.explode.enabled", true);
    }
}

