/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ExplosiveArrowEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "explosive_arrow";
    }

    @Override
    public String getDisplayName() {
        return "Explosive Arrow";
    }

    @Override
    public String getDescription() {
        return "Arrows create explosions on impact";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.RARE;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
        if (!this.isEnabled() || !(event.getEntity() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)event.getEntity();
        if (!(arrow.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)arrow.getShooter();
        ItemStack bow = player.getInventory().getItemInMainHand();
        if (!(bow != null && bow.getType().toString().contains("BOW") || (bow = player.getInventory().getItemInOffHand()) != null && bow.getType().toString().contains("BOW"))) {
            return;
        }
        if (level <= 0) {
            return;
        }
        float explosionPower = 1.0f + (float)level * 0.5f;
        arrow.getWorld().createExplosion(arrow.getLocation(), explosionPower, false, false);
        arrow.getWorld().spawnParticle(Particle.EXPLOSION, arrow.getLocation(), 3, 0.5, 0.5, 0.5, 0.1);
        arrow.getWorld().playSound(arrow.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        arrow.remove();
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.explosive_arrow.enabled", true);
    }
}

