/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FreezeEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "freeze";
    }

    @Override
    public String getDisplayName() {
        return "Freeze";
    }

    @Override
    public String getDescription() {
        return "Slows and freezes your target";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.RARE;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        int baseDuration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.freeze.base-duration-ticks", 40);
        int durationPerLevel = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.freeze.duration-per-level-ticks", 20);
        int totalDuration = baseDuration + durationPerLevel * level;
        int slownessAmplifier = Math.min(level + 1, 4);
        PotionEffect slownessEffect = new PotionEffect(PotionEffectType.SLOWNESS, totalDuration, slownessAmplifier, false, true);
        target.addPotionEffect(slownessEffect);
        if (level >= 2) {
            PotionEffect fatigueEffect = new PotionEffect(PotionEffectType.MINING_FATIGUE, totalDuration / 2, level - 1, false, true);
            target.addPotionEffect(fatigueEffect);
        }
        if (level >= 3) {
            PotionEffect weaknessEffect = new PotionEffect(PotionEffectType.WEAKNESS, totalDuration / 3, 0, false, true);
            target.addPotionEffect(weaknessEffect);
        }
        target.getWorld().spawnParticle(Particle.SNOWFLAKE, target.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 1.0, 0.5, 0.1);
        target.getWorld().spawnParticle(Particle.CLOUD, target.getLocation().add(0.0, 0.5, 0.0), 8, 0.3, 0.3, 0.3, 0.05);
        target.getWorld().playSound(target.getLocation(), Sound.BLOCK_GLASS_BREAK, 0.7f, 1.5f);
        String freezeLevel = level == 1 ? "slowed" : (level == 2 ? "frozen" : "completely frozen");
        attacker.sendMessage("\u00a7b\u2744 \u00a77Target has been \u00a7b" + freezeLevel + "\u00a77!");
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.freeze.enabled", true);
    }
}

