/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GravityWellEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "gravity_well";
    }

    @Override
    public String getDisplayName() {
        return "Gravity Well";
    }

    @Override
    public String getDescription() {
        return "Pulls nearby enemies closer on hit, restricting movement briefly";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.LEGENDARY;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        Location centerLoc = target.getLocation();
        double pullRadius = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.gravity_well.radius-per-level", 4.0) * (double)level;
        double pullStrength = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.gravity_well.pull-strength-per-level", 0.8) * (double)level;
        int slownessDuration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.gravity_well.slowness-duration-per-level", 80) * level;
        int slownessPower = Math.min(level, 3);
        ArrayList<LivingEntity> affectedEntities = new ArrayList<LivingEntity>();
        for (LivingEntity entity : centerLoc.getWorld().getLivingEntities()) {
            if (entity == attacker || !(entity.getLocation().distance(centerLoc) <= pullRadius) || entity.isDead() || entity instanceof Player && !centerLoc.getWorld().getPVP()) continue;
            affectedEntities.add(entity);
            Vector pullVector = centerLoc.toVector().subtract(entity.getLocation().toVector());
            pullVector.normalize().multiply(pullStrength);
            pullVector.setY(Math.max(pullVector.getY(), 0.2));
            entity.setVelocity(entity.getVelocity().add(pullVector));
            entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, slownessDuration, slownessPower - 1));
        }
        if (!affectedEntities.isEmpty()) {
            this.createGravityWellEffect(centerLoc, pullRadius, level);
            attacker.sendMessage("\u00a78\u26ab \u00a77Gravity Well activated! \u00a7c" + affectedEntities.size() + " \u00a77enemies pulled!");
        }
    }

    private void createGravityWellEffect(final Location center, final double radius, int level) {
        new BukkitRunnable(this){
            int duration = 60;
            double angle = 0.0;

            public void run() {
                int i;
                if (this.duration <= 0) {
                    this.cancel();
                    return;
                }
                center.getWorld().spawnParticle(Particle.SMOKE, center.clone().add(0.0, 0.5, 0.0), 5, 0.2, 0.2, 0.2, 0.01);
                for (i = 0; i < 8; ++i) {
                    double spiralAngle = this.angle + (double)i * Math.PI / 4.0;
                    double spiralRadius = radius * ((double)this.duration / 60.0);
                    double x = Math.cos(spiralAngle) * spiralRadius;
                    double z = Math.sin(spiralAngle) * spiralRadius;
                    Location particleLoc = center.clone().add(x, 0.1, z);
                    center.getWorld().spawnParticle(Particle.PORTAL, particleLoc, 2, 0.1, 0.1, 0.1, 0.02);
                    center.getWorld().spawnParticle(Particle.REVERSE_PORTAL, particleLoc.add(0.0, 0.2, 0.0), 1, 0.05, 0.05, 0.05, 0.01);
                }
                if (this.duration % 10 == 0) {
                    for (i = 0; i < 16; ++i) {
                        double ringAngle = (double)i * 0.39269908169872414;
                        double x = Math.cos(ringAngle) * (radius * 0.7);
                        double z = Math.sin(ringAngle) * (radius * 0.7);
                        center.getWorld().spawnParticle(Particle.WITCH, center.clone().add(x, 0.3, z), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                this.angle += 0.39269908169872414;
                --this.duration;
            }
        }.runTaskTimer((Plugin)CustomEnchants.getInstance(), 0L, 1L);
        center.getWorld().playSound(center, Sound.ENTITY_WITHER_SHOOT, 0.7f, 0.6f);
        center.getWorld().playSound(center, Sound.BLOCK_PORTAL_AMBIENT, 1.0f, 0.8f);
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.gravity_well.enabled", true);
    }
}

