/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class MindSpikeEnchant
extends CustomEnchant {
    private final Map<UUID, BukkitRunnable> confusionTasks = new HashMap<UUID, BukkitRunnable>();
    private final Set<UUID> confusedPlayers = new HashSet<UUID>();

    @Override
    public String getKey() {
        return "mind_spike";
    }

    @Override
    public String getDisplayName() {
        return "Mind Spike";
    }

    @Override
    public String getDescription() {
        return "Attacks confuse the target, reversing their movement controls";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.MYTHIC;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, final int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(target instanceof Player)) {
            this.applyBasicConfusion(target, level);
            return;
        }
        final Player targetPlayer = (Player)target;
        final UUID targetId = targetPlayer.getUniqueId();
        if (!targetPlayer.getWorld().getPVP()) {
            return;
        }
        if (this.confusedPlayers.contains(targetId)) {
            return;
        }
        final int confusionDuration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.mind_spike.confusion-duration-per-level", 100) * level;
        targetPlayer.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, confusionDuration, level - 1));
        targetPlayer.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, confusionDuration / 4, 0));
        this.confusedPlayers.add(targetId);
        BukkitRunnable confusionTask = new BukkitRunnable(this){
            private int ticksLeft;
            private Location lastLocation;
            final /* synthetic */ MindSpikeEnchant this$0;
            {
                this.this$0 = this$0;
                this.ticksLeft = confusionDuration;
                this.lastLocation = targetPlayer.getLocation();
            }

            public void run() {
                if (this.ticksLeft <= 0 || !targetPlayer.isOnline() || targetPlayer.isDead()) {
                    this.cleanup();
                    return;
                }
                Location currentLoc = targetPlayer.getLocation();
                if (currentLoc.distance(this.lastLocation) > 0.1) {
                    double deltaX = currentLoc.getX() - this.lastLocation.getX();
                    double deltaZ = currentLoc.getZ() - this.lastLocation.getZ();
                    Random random = new Random();
                    double reverseStrength = 0.5 + (double)level * 0.2;
                    double randomFactor = 0.8 + random.nextDouble() * 0.4;
                    double reversedX = -deltaX * reverseStrength * randomFactor;
                    double reversedZ = -deltaZ * reverseStrength * randomFactor;
                    Location newLoc = currentLoc.clone().add(reversedX, 0.0, reversedZ);
                    if (newLoc.getBlock().isSolid()) {
                        newLoc.setY(newLoc.getY() + 1.0);
                    }
                    targetPlayer.teleport(newLoc);
                    targetPlayer.getWorld().spawnParticle(Particle.SOUL, targetPlayer.getLocation().add(0.0, 2.0, 0.0), 8, 0.5, 0.5, 0.5, 0.1);
                }
                if (this.ticksLeft % 20 == 0) {
                    targetPlayer.getWorld().spawnParticle(Particle.WITCH, targetPlayer.getLocation().add(0.0, 1.0, 0.0), 10, 0.8, 1.0, 0.8, 0.05);
                    targetPlayer.playSound(targetPlayer.getLocation(), Sound.ENTITY_WITCH_AMBIENT, 0.3f, 1.5f);
                }
                this.lastLocation = targetPlayer.getLocation();
                --this.ticksLeft;
            }

            private void cleanup() {
                this.this$0.confusedPlayers.remove(targetId);
                this.this$0.confusionTasks.remove(targetId);
                this.cancel();
                if (targetPlayer.isOnline()) {
                    targetPlayer.sendMessage("\u00a77Your mind clears...");
                    targetPlayer.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, targetPlayer.getLocation().add(0.0, 2.0, 0.0), 15, 0.5, 0.5, 0.5, 0.1);
                }
            }
        };
        if (this.confusionTasks.containsKey(targetId)) {
            this.confusionTasks.get(targetId).cancel();
        }
        this.confusionTasks.put(targetId, confusionTask);
        confusionTask.runTaskTimer((Plugin)CustomEnchants.getInstance(), 0L, 1L);
        Location targetLoc = targetPlayer.getLocation();
        targetLoc.getWorld().spawnParticle(Particle.ENCHANTED_HIT, targetLoc.add(0.0, 1.0, 0.0), 20, 0.3, 1.0, 0.3, 0.2);
        targetLoc.getWorld().spawnParticle(Particle.DRAGON_BREATH, targetLoc, 15, 0.5, 0.5, 0.5, 0.1);
        targetLoc.getWorld().playSound(targetLoc, Sound.ENTITY_ELDER_GUARDIAN_CURSE, 1.0f, 1.5f);
        targetLoc.getWorld().playSound(targetLoc, Sound.ENTITY_WITCH_HURT, 0.7f, 0.8f);
        attacker.sendMessage("\u00a75\ud83e\udde0 \u00a77Mind Spike pierced " + targetPlayer.getName() + "'s thoughts!");
        targetPlayer.sendMessage("\u00a75\u2726 \u00a77Your mind feels scrambled... movement feels wrong!");
    }

    private void applyBasicConfusion(LivingEntity target, int level) {
        int duration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.mind_spike.basic-confusion-duration-per-level", 60) * level;
        target.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, duration, level - 1));
        target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, duration, 1));
        target.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, duration, 0));
        target.getWorld().spawnParticle(Particle.SOUL, target.getLocation().add(0.0, 1.0, 0.0), 12, 0.5, 0.5, 0.5, 0.1);
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.mind_spike.enabled", true);
    }

    public void cleanup() {
        for (BukkitRunnable task : this.confusionTasks.values()) {
            task.cancel();
        }
        this.confusionTasks.clear();
        this.confusedPlayers.clear();
    }
}

