/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class PiercingEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "piercing";
    }

    @Override
    public String getDisplayName() {
        return "Piercing";
    }

    @Override
    public String getDescription() {
        return "Attacks ignore a percentage of enemy armor";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.LEGENDARY;
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        if (target.getLastDamageCause() instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent event = (EntityDamageByEntityEvent)target.getLastDamageCause();
            double armorIgnorePercentage = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.piercing.armor-ignore-per-level", 0.15);
            double ignorePercent = armorIgnorePercentage * (double)level;
            double targetArmor = target.getAttribute(Attribute.ARMOR).getValue();
            double baseDamage = event.getDamage();
            double piercingDamage = baseDamage * (targetArmor / 20.0) * ignorePercent;
            if (piercingDamage > 0.0) {
                target.damage(piercingDamage, (Entity)attacker);
                attacker.sendMessage("\u00a7e\u26a1 \u00a77Piercing dealt \u00a7e" + String.format("%.1f", piercingDamage) + " \u00a77armor-piercing damage!");
            }
        }
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.piercing.enabled", true);
    }
}

