/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PoisonBladeEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "poison_blade";
    }

    @Override
    public String getDisplayName() {
        return "Poison Blade";
    }

    @Override
    public String getDescription() {
        return "Poisons your target on hit";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.COMMON;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        int baseDuration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.poison_blade.base-duration-ticks", 60);
        int durationPerLevel = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.poison_blade.duration-per-level-ticks", 20);
        int totalDuration = baseDuration + durationPerLevel * level;
        int amplifier = Math.max(0, level - 1);
        PotionEffect poisonEffect = new PotionEffect(PotionEffectType.POISON, totalDuration, amplifier, false, true);
        target.addPotionEffect(poisonEffect);
        target.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, target.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.1);
        attacker.sendMessage("\u00a72\u2620 \u00a77Target has been \u00a72poisoned\u00a77!");
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.poison_blade.enabled", true);
    }
}

