/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ShatterEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "shatter";
    }

    @Override
    public String getDisplayName() {
        return "Shatter";
    }

    @Override
    public String getDescription() {
        return "Breaks the entire connected ore vein.";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.EPIC;
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
        if (!this.isEnabled()) {
            return;
        }
        Block base = event.getBlock();
        if (!this.isOre(base.getType())) {
            return;
        }
        HashSet<Block> visited = new HashSet<Block>();
        this.breakOreVein(base, visited, player.getInventory().getItemInMainHand());
    }

    private boolean isOre(Material type) {
        return type.name().endsWith("_ORE") || type == Material.ANCIENT_DEBRIS;
    }

    private void breakOreVein(Block block, Set<Block> visited, ItemStack tool) {
        if (visited.contains(block) || !this.isOre(block.getType())) {
            return;
        }
        visited.add(block);
        block.breakNaturally(tool);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    this.breakOreVein(block.getRelative(dx, dy, dz), visited, tool);
                }
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.shatter.enabled", true);
    }
}

