/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class SoulSiphonEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "soul_siphon";
    }

    @Override
    public String getDisplayName() {
        return "Soul Siphon";
    }

    @Override
    public String getDescription() {
        return "Deals extra damage based on target's missing health";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.MYTHIC;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        double currentHealth = target.getHealth();
        double maxHealth = target.getMaxHealth();
        double missingHealthPercent = (maxHealth - currentHealth) / maxHealth;
        double bonusDamagePerLevel = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.soul_siphon.bonus-damage-per-level", 2.0);
        double bonusDamage = bonusDamagePerLevel * (double)level * missingHealthPercent;
        if (bonusDamage > 0.0) {
            target.damage(bonusDamage, (Entity)attacker);
            attacker.sendMessage("\u00a75\u26a1 \u00a77Soul Siphon dealt \u00a75" + String.format("%.1f", bonusDamage) + " \u00a77bonus damage!");
        }
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.soul_siphon.enabled", true);
    }
}

