/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class SoulguardEnchant
extends CustomEnchant {
    private static final List<Material> ARMOR_TYPES = Arrays.asList(Material.LEATHER_HELMET, Material.CHAINMAIL_HELMET, Material.IRON_HELMET, Material.DIAMOND_HELMET, Material.GOLDEN_HELMET, Material.NETHERITE_HELMET, Material.TURTLE_HELMET, Material.LEATHER_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.IRON_CHESTPLATE, Material.DIAMOND_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.NETHERITE_CHESTPLATE, Material.ELYTRA, Material.LEATHER_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.IRON_LEGGINGS, Material.DIAMOND_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.NETHERITE_LEGGINGS, Material.LEATHER_BOOTS, Material.CHAINMAIL_BOOTS, Material.IRON_BOOTS, Material.DIAMOND_BOOTS, Material.GOLDEN_BOOTS, Material.NETHERITE_BOOTS);
    private final Map<UUID, Long> shieldCooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitRunnable> activeShields = new HashMap<UUID, BukkitRunnable>();

    @Override
    public String getKey() {
        return "soulguard";
    }

    @Override
    public String getDisplayName() {
        return "Soulguard";
    }

    @Override
    public String getDescription() {
        return "Grants a protective shield when health drops below a threshold";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.MYTHIC;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
        if (!this.isEnabled()) {
            return;
        }
        int totalLevel = this.getTotalArmorEnchantLevel(player);
        if (totalLevel <= 0) {
            return;
        }
        UUID playerId = player.getUniqueId();
        if (this.activeShields.containsKey(playerId)) {
            return;
        }
        long cooldownTime = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.soulguard.cooldown-per-level", 30000) / totalLevel;
        long currentTime = System.currentTimeMillis();
        if (this.shieldCooldowns.containsKey(playerId) && currentTime - this.shieldCooldowns.get(playerId) < cooldownTime) {
            return;
        }
        double healthThreshold = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.soulguard.health-threshold-per-level", 0.3) * (double)totalLevel;
        double maxHealth = player.getMaxHealth();
        double currentHealth = player.getHealth();
        double healthPercentage = currentHealth / maxHealth;
        if (healthPercentage > healthThreshold) {
            return;
        }
        this.activateSoulguard(player, totalLevel);
        this.shieldCooldowns.put(playerId, currentTime);
    }

    private void activateSoulguard(final Player player, int totalLevel) {
        final UUID playerId = player.getUniqueId();
        final int shieldDuration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.soulguard.shield-duration-per-level", 100) * totalLevel;
        int absorptionAmount = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.soulguard.absorption-per-level", 4) * totalLevel;
        int resistanceLevel = Math.min(totalLevel, 3);
        player.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, shieldDuration, absorptionAmount - 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, shieldDuration, resistanceLevel - 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, shieldDuration / 2, 1));
        player.getWorld().spawnParticle(Particle.SOUL, player.getLocation().add(0.0, 1.0, 0.0), 30, 1.0, 1.5, 1.0, 0.1);
        player.getWorld().spawnParticle(Particle.ENCHANTED_HIT, player.getLocation().add(0.0, 1.0, 0.0), 20, 0.8, 1.0, 0.8, 0.2);
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.2f);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_GUARDIAN_AMBIENT, 0.8f, 1.5f);
        player.sendMessage("\u00a7d\u2726 \u00a77Soulguard activated! You are protected by ancient magic!");
        BukkitRunnable shieldTask = new BukkitRunnable(this){
            int ticksLeft;
            double angle;
            final /* synthetic */ SoulguardEnchant this$0;
            {
                this.this$0 = this$0;
                this.ticksLeft = shieldDuration;
                this.angle = 0.0;
            }

            public void run() {
                if (this.ticksLeft <= 0 || !player.isOnline() || player.isDead()) {
                    this.cleanup();
                    return;
                }
                for (int i = 0; i < 6; ++i) {
                    double particleAngle = this.angle + (double)i * Math.PI / 3.0;
                    double radius = 1.5 + Math.sin(this.angle * 2.0) * 0.3;
                    double x = Math.cos(particleAngle) * radius;
                    double z = Math.sin(particleAngle) * radius;
                    double y = 1.0 + Math.sin(this.angle * 3.0) * 0.2;
                    player.getWorld().spawnParticle(Particle.SOUL, player.getLocation().add(x, y, z), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.ticksLeft % 10 == 0) {
                    player.getWorld().spawnParticle(Particle.WITCH, player.getLocation().add(0.0, 1.0, 0.0), 8, 1.2, 1.0, 1.2, 0.02);
                }
                if ((double)this.ticksLeft < (double)shieldDuration * 0.3 && this.ticksLeft % 20 == 0) {
                    player.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, player.getLocation().add(0.0, 1.0, 0.0), 5, 0.5, 0.5, 0.5, 0.05);
                    player.getWorld().playSound(player.getLocation(), Sound.BLOCK_SOUL_SAND_BREAK, 0.3f, 1.5f);
                }
                this.angle += 0.19634954084936207;
                --this.ticksLeft;
            }

            private void cleanup() {
                this.this$0.activeShields.remove(playerId);
                this.cancel();
                if (player.isOnline()) {
                    player.sendMessage("\u00a77The Soulguard shield fades away...");
                    player.getWorld().spawnParticle(Particle.SOUL, player.getLocation().add(0.0, 1.0, 0.0), 15, 1.0, 1.0, 1.0, 0.2);
                    player.getWorld().playSound(player.getLocation(), Sound.BLOCK_SOUL_SAND_BREAK, 0.5f, 0.8f);
                }
            }
        };
        this.activeShields.put(playerId, shieldTask);
        shieldTask.runTaskTimer((Plugin)CustomEnchants.getInstance(), 0L, 2L);
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    private int getTotalArmorEnchantLevel(Player player) {
        ItemStack[] armorContents;
        PlayerInventory inventory = player.getInventory();
        int totalLevel = 0;
        for (ItemStack armor : armorContents = inventory.getArmorContents()) {
            if (armor == null || !this.isValidArmorType(armor.getType())) continue;
            int enchantLevel = this.getEnchantLevelFromItem(armor);
            totalLevel += enchantLevel;
        }
        return totalLevel;
    }

    private boolean isValidArmorType(Material material) {
        return ARMOR_TYPES.contains(material);
    }

    private int getEnchantLevelFromItem(ItemStack item) {
        return 0;
    }

    public List<Material> getValidArmorTypes() {
        return ARMOR_TYPES;
    }

    public boolean canApplyTo(Material material) {
        return this.isValidArmorType(material);
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.soulguard.enabled", true);
    }

    public void cleanup() {
        for (BukkitRunnable task : this.activeShields.values()) {
            task.cancel();
        }
        this.activeShields.clear();
        this.shieldCooldowns.clear();
    }
}

