/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SunflareEnchant
extends CustomEnchant {
    private final Random random = new Random();

    @Override
    public String getKey() {
        return "sunflare";
    }

    @Override
    public String getDisplayName() {
        return "Sunflare";
    }

    @Override
    public String getDescription() {
        return "Emits a blinding flash on critical hits, causing nearby enemies to miss their attacks";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.EPIC;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        double critChance = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.sunflare.crit-chance-per-level", 0.15) * (double)level;
        if (this.random.nextDouble() > critChance) {
            return;
        }
        Location targetLoc = target.getLocation();
        double radius = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.sunflare.radius", 5.0);
        int blindnessDuration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.sunflare.blindness-duration-per-level", 60) * level;
        int weaknessDuration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.sunflare.weakness-duration-per-level", 40) * level;
        int entitiesBlinded = 0;
        for (LivingEntity entity : targetLoc.getWorld().getLivingEntities()) {
            if (entity == attacker || !(entity.getLocation().distance(targetLoc) <= radius) || entity.isDead() || entity instanceof Player && !targetLoc.getWorld().getPVP()) continue;
            entity.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, blindnessDuration, 0));
            entity.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, weaknessDuration, 0));
            ++entitiesBlinded;
            entity.getWorld().spawnParticle(Particle.FLASH, entity.getLocation().add(0.0, 1.0, 0.0), 3, 0.5, 0.5, 0.5, 0.1);
        }
        targetLoc.getWorld().spawnParticle(Particle.FLASH, targetLoc.add(0.0, 1.0, 0.0), 15, radius / 2.0, 1.0, radius / 2.0, 0.1);
        targetLoc.getWorld().spawnParticle(Particle.END_ROD, targetLoc, 20, radius / 3.0, 0.5, radius / 3.0, 0.2);
        targetLoc.getWorld().spawnParticle(Particle.FLAME, targetLoc, 12, radius / 4.0, 0.3, radius / 4.0, 0.05);
        targetLoc.getWorld().playSound(targetLoc, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 0.5f, 1.5f);
        targetLoc.getWorld().playSound(targetLoc, Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.2f);
        if (entitiesBlinded > 0) {
            attacker.sendMessage("\u00a76\u2600 \u00a77Sunflare activated! \u00a7e" + entitiesBlinded + " \u00a77enemies blinded!");
        }
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.sunflare.enabled", true);
    }
}

