/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class TimberEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "timber";
    }

    @Override
    public String getDisplayName() {
        return "Timber";
    }

    @Override
    public String getDescription() {
        return "Breaks entire tree instantly.";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.RARE;
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
        if (!this.isEnabled()) {
            return;
        }
        Block base = event.getBlock();
        Material type = base.getType();
        if (!type.name().endsWith("LOG")) {
            return;
        }
        HashSet<Block> visited = new HashSet<Block>();
        this.breakConnectedLogs(base, visited, player.getInventory().getItemInMainHand());
    }

    private void breakConnectedLogs(Block block, Set<Block> visited, ItemStack tool) {
        if (visited.contains(block) || !block.getType().name().endsWith("LOG")) {
            return;
        }
        visited.add(block);
        block.breakNaturally(tool);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    this.breakConnectedLogs(block.getRelative(dx, dy, dz), visited, tool);
                }
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.timber.enabled", true);
    }
}

