/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.listeners;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;

public class AnvilListener
implements Listener {
    private final CustomEnchants plugin;

    public AnvilListener(CustomEnchants plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        Object existingEnchants;
        AnvilInventory anvil = event.getInventory();
        ItemStack firstItem = anvil.getItem(0);
        ItemStack secondItem = anvil.getItem(1);
        if (firstItem == null || secondItem == null) {
            return;
        }
        if (secondItem.getType() != Material.ENCHANTED_BOOK) {
            return;
        }
        Map<String, Integer> bookEnchants = this.plugin.getEnchantmentManager().getCustomEnchantments(secondItem);
        if (bookEnchants.isEmpty()) {
            return;
        }
        boolean canApply = false;
        for (String enchantKey : bookEnchants.keySet()) {
            CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
            if (enchant == null || !enchant.canEnchantItem(firstItem)) continue;
            canApply = true;
            break;
        }
        if (!canApply) {
            return;
        }
        ItemStack result = firstItem.clone();
        boolean allowStacking = this.plugin.getConfigManager().getBoolean("enchantments.allow-stacking", true);
        if (!allowStacking && !(existingEnchants = this.plugin.getEnchantmentManager().getCustomEnchantments(result)).isEmpty()) {
            return;
        }
        for (Map.Entry entry : bookEnchants.entrySet()) {
            String enchantKey = (String)entry.getKey();
            int bookLevel = (Integer)entry.getValue();
            CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
            if (enchant == null || !enchant.canEnchantItem(result)) continue;
            int existingLevel = this.plugin.getEnchantmentManager().getEnchantmentLevel(result, enchantKey);
            int finalLevel = existingLevel > 0 ? (existingLevel == bookLevel && existingLevel < enchant.getMaxLevel() ? existingLevel + 1 : Math.max(existingLevel, bookLevel)) : bookLevel;
            finalLevel = Math.min(finalLevel, enchant.getMaxLevel());
            this.plugin.getEnchantmentManager().addEnchantment(result, enchantKey, finalLevel);
        }
        ItemStack resultz = anvil.getItem(2);
        if (resultz != null && resultz.getType() != Material.AIR) {
            int n = this.calculateRepairCost(bookEnchants);
            ItemMeta meta = resultz.getItemMeta();
            if (meta instanceof Repairable) {
                Repairable repairable = (Repairable)meta;
                repairable.setRepairCost(n);
                resultz.setItemMeta((ItemMeta)repairable);
                anvil.setItem(2, resultz);
            }
        }
        event.setResult(result);
    }

    private int calculateRepairCost(Map<String, Integer> enchantments) {
        int baseCost = this.plugin.getConfigManager().getInt("enchantments.anvil-base-cost", 5);
        int costPerLevel = this.plugin.getConfigManager().getInt("enchantments.anvil-cost-per-level", 2);
        int rarityCostMultiplier = this.plugin.getConfigManager().getInt("enchantments.anvil-rarity-multiplier", 1);
        int totalCost = baseCost;
        for (Map.Entry<String, Integer> entry : enchantments.entrySet()) {
            String enchantKey = entry.getKey();
            int level = entry.getValue();
            CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
            if (enchant == null) continue;
            int rarityMultiplier = this.getRarityMultiplier(enchant.getRarity());
            totalCost += level * costPerLevel * rarityMultiplier * rarityCostMultiplier;
        }
        return Math.min(totalCost, 39);
    }

    private int getRarityMultiplier(EnchantRarity rarity) {
        switch (rarity) {
            case COMMON: {
                return 1;
            }
            case RARE: {
                return 2;
            }
            case EPIC: {
                return 3;
            }
            case LEGENDARY: {
                return 4;
            }
            case MYTHIC: {
                return 5;
            }
        }
        return 1;
    }
}

