/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.listeners;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class CombatListener
implements Listener {
    private final CustomEnchants plugin;

    public CombatListener(CustomEnchants plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        Player attacker = (Player)event.getDamager();
        LivingEntity target = (LivingEntity)event.getEntity();
        ItemStack weapon = attacker.getInventory().getItemInMainHand();
        if (weapon.getType().isAir()) {
            return;
        }
        Map<String, Integer> customEnchants = this.plugin.getEnchantmentManager().getCustomEnchantments(weapon);
        if (customEnchants.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Integer> entry : customEnchants.entrySet()) {
            String enchantKey = entry.getKey();
            int level = entry.getValue();
            CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
            if (enchant == null || !enchant.isEnabled() || !enchant.canEnchantItem(weapon)) continue;
            enchant.onAttack(attacker, target, level, weapon);
        }
    }
}

