/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.listeners;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.inventory.ItemStack;

public class EnchantmentTableListener
implements Listener {
    private final CustomEnchants plugin;
    private final Random random = new Random();

    public EnchantmentTableListener(CustomEnchants plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPrepareItemEnchant(PrepareItemEnchantEvent event) {
        ItemStack item = event.getItem();
        Player player = event.getEnchanter();
        if (!this.plugin.getConfigManager().getBoolean("enchantments.enable-enchantment-table", true)) {
            return;
        }
        List<CustomEnchant> availableEnchants = this.getAvailableEnchantments(item);
        if (availableEnchants.isEmpty()) {
            return;
        }
        int[] expLevelCosts = event.getExpLevelCostsOffered();
        for (int i = 0; i < expLevelCosts.length; ++i) {
            if (expLevelCosts[i] <= 0) continue;
            double customChance = this.calculateCustomEnchantChance(expLevelCosts[i]);
            if (!(this.random.nextDouble() < customChance)) continue;
            int additionalCost = this.plugin.getConfigManager().getInt("enchantments.table-additional-cost", 2);
            expLevelCosts[i] = Math.min(expLevelCosts[i] + additionalCost, 30);
        }
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        Map<String, Integer> existingCustom;
        ItemStack item = event.getItem();
        Player player = event.getEnchanter();
        int expLevelCost = event.getExpLevelCost();
        if (!this.plugin.getConfigManager().getBoolean("enchantments.enable-enchantment-table", true)) {
            return;
        }
        List<CustomEnchant> availableEnchants = this.getAvailableEnchantments(item);
        if (availableEnchants.isEmpty()) {
            return;
        }
        double customChance = this.calculateCustomEnchantChance(expLevelCost);
        if (this.random.nextDouble() >= customChance) {
            return;
        }
        List<CustomEnchant> enchantsToApply = this.selectEnchantments(availableEnchants, expLevelCost);
        if (enchantsToApply.isEmpty()) {
            return;
        }
        boolean allowStacking = this.plugin.getConfigManager().getBoolean("enchantments.allow-stacking", true);
        if (!allowStacking && !(existingCustom = this.plugin.getEnchantmentManager().getCustomEnchantments(item)).isEmpty()) {
            return;
        }
        for (CustomEnchant enchant : enchantsToApply) {
            int level = this.calculateEnchantmentLevel(enchant, expLevelCost);
            int existingLevel = this.plugin.getEnchantmentManager().getEnchantmentLevel(item, enchant.getKey());
            if (existingLevel > 0 && !allowStacking) continue;
            this.plugin.getEnchantmentManager().addEnchantment(item, enchant.getKey(), level);
        }
        if (item.getType() == Material.BOOK) {
            item.setType(Material.ENCHANTED_BOOK);
        }
    }

    private List<CustomEnchant> getAvailableEnchantments(ItemStack item) {
        ArrayList<CustomEnchant> available = new ArrayList<CustomEnchant>();
        for (CustomEnchant enchant : this.plugin.getEnchantmentManager().getAllEnchantments().values()) {
            boolean tableEnabled;
            if (!enchant.canEnchantItem(item) || !(tableEnabled = this.plugin.getConfigManager().getBoolean("enchantments.custom." + enchant.getKey() + ".enchantment-table", true))) continue;
            available.add(enchant);
        }
        return available;
    }

    private double calculateCustomEnchantChance(int expLevelCost) {
        double baseChance = this.plugin.getConfigManager().getDouble("enchantments.table-custom-chance", 0.15);
        double levelMultiplier = this.plugin.getConfigManager().getDouble("enchantments.table-level-multiplier", 0.02);
        return Math.min(baseChance + (double)expLevelCost * levelMultiplier, 0.8);
    }

    private List<CustomEnchant> selectEnchantments(List<CustomEnchant> available, int expLevelCost) {
        ArrayList<CustomEnchant> selected = new ArrayList<CustomEnchant>();
        HashMap<CustomEnchant, Double> weights = new HashMap<CustomEnchant, Double>();
        double totalWeight = 0.0;
        for (CustomEnchant enchant : available) {
            double weight = this.getRarityWeight(enchant.getRarity(), expLevelCost);
            weights.put(enchant, weight);
            totalWeight += weight;
        }
        double roll = this.random.nextDouble() * totalWeight;
        double current = 0.0;
        for (Map.Entry entry : weights.entrySet()) {
            if (!(roll <= (current += ((Double)entry.getValue()).doubleValue()))) continue;
            selected.add((CustomEnchant)entry.getKey());
            break;
        }
        if (expLevelCost >= 20 && this.random.nextDouble() < 0.3) {
            available.removeAll(selected);
            if (!available.isEmpty()) {
                CustomEnchant bonus = available.get(this.random.nextInt(available.size()));
                boolean conflict = false;
                for (CustomEnchant existing : selected) {
                    if (!existing.getConflictingEnchantments().contains(bonus.getKey()) && !bonus.getConflictingEnchantments().contains(existing.getKey())) continue;
                    conflict = true;
                    break;
                }
                if (!conflict) {
                    selected.add(bonus);
                }
            }
        }
        return selected;
    }

    private double getRarityWeight(EnchantRarity rarity, int expLevelCost) {
        double baseWeight = switch (rarity) {
            case EnchantRarity.COMMON -> 50.0;
            case EnchantRarity.RARE -> 25.0;
            case EnchantRarity.EPIC -> 10.0;
            case EnchantRarity.LEGENDARY -> 3.0;
            case EnchantRarity.MYTHIC -> 1.0;
            default -> 50.0;
        };
        double levelMultiplier = 1.0 + (double)expLevelCost / 30.0;
        if (rarity != EnchantRarity.COMMON) {
            baseWeight *= levelMultiplier;
        }
        return baseWeight;
    }

    private int calculateEnchantmentLevel(CustomEnchant enchant, int expLevelCost) {
        int maxLevel = enchant.getMaxLevel();
        if (maxLevel == 1) {
            return 1;
        }
        int level = 1;
        for (double levelUpChance = Math.min((double)expLevelCost / 30.0, 0.8); level < maxLevel && this.random.nextDouble() < levelUpChance; ++level, levelUpChance *= 0.6) {
        }
        return level;
    }
}

