/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.listeners;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareGrindstoneEvent;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;

public class GrinderListener
implements Listener {
    private final CustomEnchants plugin;

    public GrinderListener(CustomEnchants plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPrepareGrindstone(PrepareGrindstoneEvent event) {
        GrindstoneInventory grindstone = event.getInventory();
        ItemStack firstItem = grindstone.getItem(0);
        ItemStack secondItem = grindstone.getItem(1);
        if (!this.plugin.getConfigManager().getBoolean("enchantments.enable-grindstone", true)) {
            return;
        }
        ItemStack result = null;
        if (firstItem != null && (secondItem == null || secondItem.getType() == Material.AIR)) {
            result = this.handleSingleItemDisenchant(firstItem);
        } else if (firstItem != null && secondItem != null && firstItem.getType() == secondItem.getType() && !firstItem.getType().isAir() && !secondItem.getType().isAir()) {
            result = this.handleItemRepair(firstItem, secondItem);
        }
        if (result != null) {
            event.setResult(result);
        }
    }

    private ItemStack handleSingleItemDisenchant(ItemStack item) {
        int expReward;
        EnchantmentStorageMeta storageMeta;
        boolean hasVanillaEnchants;
        Map<String, Integer> customEnchants = this.plugin.getEnchantmentManager().getCustomEnchantments(item);
        boolean bl = hasVanillaEnchants = !item.getEnchantments().isEmpty();
        if (customEnchants.isEmpty() && !hasVanillaEnchants) {
            return null;
        }
        ItemStack result = item.clone();
        for (Enchantment enchant : result.getEnchantments().keySet()) {
            result.removeEnchantment(enchant);
        }
        for (String enchantKey : customEnchants.keySet()) {
            this.plugin.getEnchantmentManager().removeEnchantment(result, enchantKey);
        }
        ItemMeta meta = result.getItemMeta();
        if (meta instanceof Repairable) {
            Repairable repairable = (Repairable)meta;
            repairable.setRepairCost(0);
            result.setItemMeta((ItemMeta)repairable);
        }
        if (result.getType() == Material.ENCHANTED_BOOK && (storageMeta = (EnchantmentStorageMeta)result.getItemMeta()) != null && storageMeta.getStoredEnchants().isEmpty()) {
            result.setType(Material.BOOK);
            result.setItemMeta(null);
        }
        if ((expReward = this.calculateExperienceReward(customEnchants, item.getEnchantments())) <= 0 || meta != null) {
            // empty if block
        }
        return result;
    }

    private ItemStack handleItemRepair(ItemStack firstItem, ItemStack secondItem) {
        ItemMeta meta;
        if (firstItem.getType().getMaxDurability() <= 0) {
            return null;
        }
        ItemStack result = firstItem.clone();
        Map<String, Integer> firstCustomEnchants = this.plugin.getEnchantmentManager().getCustomEnchantments(firstItem);
        Map<String, Integer> secondCustomEnchants = this.plugin.getEnchantmentManager().getCustomEnchantments(secondItem);
        short firstDamage = firstItem.getDurability();
        short secondDamage = secondItem.getDurability();
        short maxDurability = firstItem.getType().getMaxDurability();
        int totalDurability = maxDurability - firstDamage + (maxDurability - secondDamage);
        int bonusDurability = (int)((double)maxDurability * 0.05);
        int newDurability = Math.min(maxDurability, totalDurability + bonusDurability);
        result.setDurability((short)(maxDurability - newDurability));
        boolean removeEnchantsOnRepair = this.plugin.getConfigManager().getBoolean("enchantments.grindstone-removes-on-repair", true);
        if (removeEnchantsOnRepair) {
            for (Enchantment enchant : result.getEnchantments().keySet()) {
                result.removeEnchantment(enchant);
            }
            for (String enchantKey : firstCustomEnchants.keySet()) {
                this.plugin.getEnchantmentManager().removeEnchantment(result, enchantKey);
            }
        } else {
            for (Map.Entry<String, Integer> entry : secondCustomEnchants.entrySet()) {
                int firstLevel;
                String enchantKey = entry.getKey();
                int secondLevel = entry.getValue();
                if (secondLevel <= (firstLevel = firstCustomEnchants.getOrDefault(enchantKey, 0).intValue())) continue;
                this.plugin.getEnchantmentManager().addEnchantment(result, enchantKey, secondLevel);
            }
        }
        if ((meta = result.getItemMeta()) instanceof Repairable) {
            Repairable repairable = (Repairable)meta;
            repairable.setRepairCost(0);
            result.setItemMeta((ItemMeta)repairable);
        }
        return result;
    }

    private int calculateExperienceReward(Map<String, Integer> customEnchants, Map<Enchantment, Integer> vanillaEnchants) {
        int totalExp = 0;
        int baseExpPerEnchant = this.plugin.getConfigManager().getInt("enchantments.grindstone-base-exp", 2);
        int expPerLevel = this.plugin.getConfigManager().getInt("enchantments.grindstone-exp-per-level", 1);
        for (Map.Entry<String, Integer> entry : customEnchants.entrySet()) {
            String enchantKey = entry.getKey();
            int level = entry.getValue();
            totalExp += baseExpPerEnchant;
            totalExp += (level - 1) * expPerLevel;
            CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
            if (enchant == null) continue;
            totalExp += this.getRarityExpBonus(enchant.getRarity());
        }
        for (Map.Entry<String, Integer> entry : vanillaEnchants.entrySet()) {
            int level = entry.getValue();
            totalExp += baseExpPerEnchant + (level - 1) * expPerLevel;
        }
        int maxExp = this.plugin.getConfigManager().getInt("enchantments.grindstone-max-exp", 50);
        return Math.min(totalExp, maxExp);
    }

    private int getRarityExpBonus(EnchantRarity rarity) {
        switch (rarity) {
            case COMMON: {
                return 0;
            }
            case RARE: {
                return 2;
            }
            case EPIC: {
                return 5;
            }
            case LEGENDARY: {
                return 10;
            }
            case MYTHIC: {
                return 15;
            }
        }
        return 0;
    }
}

