/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.utils;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import java.util.Map;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlaceholderHook
extends PlaceholderExpansion {
    private final CustomEnchants plugin;

    public PlaceholderHook(CustomEnchants plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "customenchants";
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, String params) {
        if (player == null) {
            return "";
        }
        if (params.startsWith("mainhand_")) {
            String enchantKey = params.substring(9);
            ItemStack mainHand = player.getInventory().getItemInMainHand();
            if (mainHand == null || mainHand.getType().isAir()) {
                return "0";
            }
            int level = this.plugin.getEnchantmentManager().getEnchantmentLevel(mainHand, enchantKey);
            return String.valueOf(level);
        }
        if (params.startsWith("offhand_")) {
            String enchantKey = params.substring(8);
            ItemStack offHand = player.getInventory().getItemInOffHand();
            if (offHand == null || offHand.getType().isAir()) {
                return "0";
            }
            int level = this.plugin.getEnchantmentManager().getEnchantmentLevel(offHand, enchantKey);
            return String.valueOf(level);
        }
        if (params.equals("mainhand_count")) {
            ItemStack mainHand = player.getInventory().getItemInMainHand();
            if (mainHand == null || mainHand.getType().isAir()) {
                return "0";
            }
            Map<String, Integer> enchants = this.plugin.getEnchantmentManager().getCustomEnchantments(mainHand);
            return String.valueOf(enchants.size());
        }
        if (params.equals("mainhand_list")) {
            ItemStack mainHand = player.getInventory().getItemInMainHand();
            if (mainHand == null || mainHand.getType().isAir()) {
                return "None";
            }
            Map<String, Integer> enchants = this.plugin.getEnchantmentManager().getCustomEnchantments(mainHand);
            if (enchants.isEmpty()) {
                return "None";
            }
            StringBuilder list = new StringBuilder();
            for (Map.Entry<String, Integer> entry : enchants.entrySet()) {
                CustomEnchant enchant;
                if (list.length() > 0) {
                    list.append(", ");
                }
                if ((enchant = this.plugin.getEnchantmentManager().getEnchantment(entry.getKey())) == null) continue;
                list.append(enchant.getDisplayName()).append(" ").append(entry.getValue());
            }
            return list.toString();
        }
        if (params.startsWith("has_")) {
            String enchantKey = params.substring(4);
            ItemStack mainHand = player.getInventory().getItemInMainHand();
            if (mainHand != null && !mainHand.getType().isAir() && this.plugin.getEnchantmentManager().hasCustomEnchantment(mainHand, enchantKey)) {
                return "true";
            }
            ItemStack offHand = player.getInventory().getItemInOffHand();
            if (offHand != null && !offHand.getType().isAir() && this.plugin.getEnchantmentManager().hasCustomEnchantment(offHand, enchantKey)) {
                return "true";
            }
            return "false";
        }
        if (params.startsWith("enchant_") && params.endsWith("_name")) {
            String enchantKey = params.substring(8, params.length() - 5);
            CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
            if (enchant != null) {
                return enchant.getDisplayName();
            }
            return "Unknown";
        }
        if (params.startsWith("enchant_") && params.endsWith("_rarity")) {
            String enchantKey = params.substring(8, params.length() - 7);
            CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
            if (enchant != null) {
                return enchant.getRarity().name();
            }
            return "Unknown";
        }
        return null;
    }
}

