/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.commands;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CustomEnchantsCommand
implements CommandExecutor,
TabCompleter {
    private final CustomEnchants plugin;

    public CustomEnchantsCommand(CustomEnchants plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "list": {
                this.listEnchantments(sender);
                break;
            }
            case "give": {
                if (args.length < 4) {
                    sender.sendMessage("\u00a7cUsage: /" + label + " give <player> <enchant> <level>");
                    return true;
                }
                this.giveEnchantedBook(sender, args[1], args[2], args[3]);
                break;
            }
            case "reload": {
                if (!sender.hasPermission("customenchants.reload")) {
                    sender.sendMessage("\u00a7cYou don't have permission to reload the plugin!");
                    return true;
                }
                this.reloadPlugin(sender);
                break;
            }
            case "books": {
                if (sender instanceof Player) {
                    sender.sendMessage("\u00a7eCustom enchants GUI coming soon! Stay tuned.");
                }
                return true;
            }
            default: {
                this.showHelp(sender);
            }
        }
        return true;
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== Custom Enchants Help ===");
        sender.sendMessage("\u00a7e/customenchants list \u00a77- List all custom enchantments");
        sender.sendMessage("\u00a7e/ce give <player> <enchant> <level> \u00a77- Give enchanted book");
        sender.sendMessage("\u00a7e/customenchants reload \u00a77- Reload plugin configuration");
        sender.sendMessage("\u00a7e/customenchants books \u00a77- All of the books in a gui");
        sender.sendMessage("\u00a7e/customenchants help \u00a77- Show this help message");
        sender.sendMessage("");
        sender.sendMessage("\u00a77Available enchantments: \u00a7flifesteal, explode, poison_blade, freeze, blinding, lightning_strike, berserker, explosive_arrow, thorns_aura");
    }

    private void listEnchantments(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== Custom Enchantments ===");
        Map<String, CustomEnchant> enchantments = this.plugin.getEnchantmentManager().getAllEnchantments();
        for (CustomEnchant enchant : enchantments.values()) {
            String rarityColor = this.getRarityColor(enchant.getRarity());
            String enabledStatus = enchant.isEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled";
            sender.sendMessage("\u00a7e" + enchant.getDisplayName() + " \u00a77(" + rarityColor + enchant.getRarity().name() + "\u00a77) - " + enabledStatus);
            sender.sendMessage("  \u00a77" + enchant.getDescription());
            sender.sendMessage("  \u00a77Max Level: \u00a7f" + enchant.getMaxLevel());
            sender.sendMessage("");
        }
    }

    private void giveEnchantedBook(CommandSender sender, String playerName, String enchantKey, String levelStr) {
        int level;
        if (!sender.hasPermission("customenchants.give")) {
            sender.sendMessage("\u00a7cYou don't have permission to give enchanted books!");
            return;
        }
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found: " + playerName);
            return;
        }
        CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
        if (enchant == null) {
            sender.sendMessage("\u00a7cUnknown enchantment: " + enchantKey);
            return;
        }
        try {
            level = Integer.parseInt(levelStr);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid level: " + levelStr);
            return;
        }
        if (level < 1 || level > enchant.getMaxLevel()) {
            sender.sendMessage("\u00a7cLevel must be between 1 and " + enchant.getMaxLevel());
            return;
        }
        ItemStack book = this.plugin.getEnchantmentManager().createEnchantedBook(enchantKey, level);
        if (book == null) {
            sender.sendMessage("\u00a7cFailed to create enchanted book!");
            return;
        }
        if (target.getInventory().firstEmpty() == -1) {
            target.getWorld().dropItem(target.getLocation(), book);
            target.sendMessage("\u00a77Your inventory was full, so the enchanted book was dropped!");
        } else {
            target.getInventory().addItem(new ItemStack[]{book});
        }
        String rarityColor = this.getRarityColor(enchant.getRarity());
        sender.sendMessage("\u00a7aGave " + target.getName() + " a " + rarityColor + enchant.getDisplayName() + " " + level + " \u00a7aenchanted book!");
        target.sendMessage("\u00a7aYou received a " + rarityColor + enchant.getDisplayName() + " " + level + " \u00a7aenchanted book!");
    }

    private void reloadPlugin(CommandSender sender) {
        this.plugin.getConfigManager().reloadConfig();
        sender.sendMessage("\u00a7aCustom Enchants configuration reloaded!");
    }

    private String getRarityColor(EnchantRarity rarity) {
        switch (rarity) {
            case COMMON: {
                return "\u00a7f";
            }
            case RARE: {
                return "\u00a79";
            }
            case EPIC: {
                return "\u00a7d";
            }
            case LEGENDARY: {
                return "\u00a76";
            }
        }
        return "\u00a77";
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block4: {
            block6: {
                block5: {
                    block3: {
                        completions = new ArrayList<String>();
                        if (args.length != 1) break block3;
                        completions.addAll(Arrays.asList("list", "give", "reload", "help"));
                        break block4;
                    }
                    if (args.length != 2 || !args[0].equalsIgnoreCase("give")) break block5;
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        completions.add(player.getName());
                    }
                    break block4;
                }
                if (args.length != 3 || !args[0].equalsIgnoreCase("give")) break block6;
                completions.addAll(this.plugin.getEnchantmentManager().getEnchantmentKeys());
                break block4;
            }
            if (args.length != 4 || !args[0].equalsIgnoreCase("give")) break block4;
            String enchantKey = args[2];
            CustomEnchant enchant = this.plugin.getEnchantmentManager().getEnchantment(enchantKey);
            if (enchant != null) {
                for (int i = 1; i <= enchant.getMaxLevel(); ++i) {
                    completions.add(String.valueOf(i));
                }
            }
        }
        return completions;
    }
}

