/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public abstract class CustomEnchant {
    public abstract String getKey();

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract EnchantRarity getRarity();

    public abstract int getMaxLevel();

    public abstract void onRightClick(PlayerInteractEvent var1, Player var2, int var3);

    public abstract void onAttack(Player var1, LivingEntity var2, int var3, ItemStack var4);

    public boolean canEnchantItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        return switch (item.getType()) {
            case Material.WOODEN_SWORD, Material.STONE_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.DIAMOND_SWORD, Material.NETHERITE_SWORD, Material.WOODEN_AXE, Material.STONE_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.DIAMOND_AXE, Material.NETHERITE_AXE, Material.WOODEN_PICKAXE, Material.STONE_PICKAXE, Material.IRON_PICKAXE, Material.GOLDEN_PICKAXE, Material.DIAMOND_PICKAXE, Material.NETHERITE_PICKAXE, Material.WOODEN_SHOVEL, Material.STONE_SHOVEL, Material.IRON_SHOVEL, Material.GOLDEN_SHOVEL, Material.DIAMOND_SHOVEL, Material.NETHERITE_SHOVEL, Material.WOODEN_HOE, Material.STONE_HOE, Material.IRON_HOE, Material.GOLDEN_HOE, Material.DIAMOND_HOE, Material.NETHERITE_HOE, Material.BOW, Material.CROSSBOW, Material.TRIDENT, Material.MACE, Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS, Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS, Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS -> true;
            default -> false;
        };
    }

    public abstract void onDamageReceived(Player var1, EntityDamageEvent var2, int var3);

    public abstract void onProjectileHit(ProjectileHitEvent var1, Player var2, int var3);

    public abstract void onBlockBreak(BlockBreakEvent var1, Player var2, int var3);

    public boolean isEnabled() {
        return true;
    }
}

