/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class DashEnchant
extends CustomEnchant {
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    @Override
    public String getKey() {
        return "dash";
    }

    @Override
    public String getDisplayName() {
        return "Dash";
    }

    @Override
    public String getDescription() {
        return "Right-click to dash forward through enemies";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.EPIC;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
        long cooldownMs;
        long timeSinceLast;
        if (!this.isEnabled()) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || !this.isSword(item.getType())) {
            return;
        }
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        int cooldownSeconds = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.dash.cooldown-seconds", 5);
        if (this.cooldowns.containsKey(playerId) && (timeSinceLast = currentTime - this.cooldowns.get(playerId)) < (cooldownMs = (long)cooldownSeconds * 1000L)) {
            long remainingSeconds = (cooldownMs - timeSinceLast) / 1000L;
            player.sendMessage("\u00a7c\u26a1 \u00a77Dash is on cooldown for \u00a7c" + remainingSeconds + " \u00a77seconds!");
            return;
        }
        this.performDash(player, level);
        this.cooldowns.put(playerId, currentTime);
        event.setCancelled(true);
    }

    private void performDash(final Player player, final int level) {
        double baseDistance = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.dash.base-distance", 5.0);
        double distancePerLevel = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.dash.distance-per-level", 2.0);
        double dashDistance = baseDistance + distancePerLevel * (double)(level - 1);
        final Vector direction = player.getLocation().getDirection().normalize();
        direction.setY(0.2);
        Vector dashVelocity = direction.multiply(dashDistance / 10.0);
        Location startLoc = player.getLocation().clone();
        player.setVelocity(dashVelocity);
        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.5f);
        new BukkitRunnable(this){
            int ticks = 0;
            final int maxTicks = 20;

            public void run() {
                if (this.ticks >= 20) {
                    this.cancel();
                    return;
                }
                Location playerLoc = player.getLocation();
                for (int i = 0; i < 3; ++i) {
                    Location particleLoc = playerLoc.clone().subtract(direction.clone().multiply((double)i * 0.5));
                    particleLoc.getWorld().spawnParticle(Particle.CLOUD, particleLoc, 2, 0.2, 0.2, 0.2, 0.1);
                    particleLoc.getWorld().spawnParticle(Particle.CRIT, particleLoc, 1, 0.1, 0.1, 0.1, 0.1);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)CustomEnchants.getInstance(), 0L, 1L);
        new BukkitRunnable(this){

            public void run() {
                player.sendMessage("\u00a79\u26a1 \u00a77Dash activated! \u00a79Level " + level);
            }
        }.runTaskLater((Plugin)CustomEnchants.getInstance(), 5L);
    }

    private boolean isSword(Material material) {
        return material == Material.WOODEN_SWORD || material == Material.STONE_SWORD || material == Material.IRON_SWORD || material == Material.GOLDEN_SWORD || material == Material.DIAMOND_SWORD || material == Material.NETHERITE_SWORD;
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        long timeSinceDash;
        UUID playerId = attacker.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.cooldowns.containsKey(playerId) && (timeSinceDash = currentTime - this.cooldowns.get(playerId)) < 3000L) {
            double bonusDamage = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.dash.bonus-damage-per-level", 1.5);
            double totalBonus = bonusDamage * (double)level;
            target.damage(totalBonus, (Entity)attacker);
            attacker.sendMessage("\u00a79\u26a1 \u00a77Dash Strike! \u00a79+" + String.format("%.1f", totalBonus) + " \u00a77damage!");
            target.getLocation().getWorld().spawnParticle(Particle.CRIT, target.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.1);
        }
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.dash.enabled", true);
    }
}

