/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class EchoStepEnchant
extends CustomEnchant {
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    @Override
    public String getKey() {
        return "echo_step";
    }

    @Override
    public String getDisplayName() {
        return "Echo Step";
    }

    @Override
    public String getDescription() {
        return "Allows you to teleport a short distance behind your target after hitting them";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.RARE;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        long cooldownTime = CustomEnchants.getInstance().getConfigManager().getLong("enchantments.echo_step.cooldown-per-level", 5000L) / (long)level;
        UUID playerId = attacker.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.cooldowns.containsKey(playerId) && currentTime - this.cooldowns.get(playerId) < cooldownTime) {
            return;
        }
        double teleportDistance = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.echo_step.distance-per-level", 1.5) * (double)level;
        Location targetLoc = target.getLocation();
        Location attackerLoc = attacker.getLocation();
        Vector direction = targetLoc.toVector().subtract(attackerLoc.toVector()).normalize();
        Vector behindTarget = direction.multiply(-teleportDistance);
        Location teleportLoc = targetLoc.clone().add(behindTarget);
        teleportLoc.setY(targetLoc.getY());
        while (teleportLoc.getBlock().isSolid() && teleportLoc.getY() < targetLoc.getY() + 5.0) {
            teleportLoc.add(0.0, 1.0, 0.0);
        }
        Location groundCheck = teleportLoc.clone().subtract(0.0, 1.0, 0.0);
        if (!groundCheck.getBlock().isSolid()) {
            for (int i = 1; i <= 3; ++i) {
                groundCheck = teleportLoc.clone().subtract(0.0, (double)(i + 1), 0.0);
                if (!groundCheck.getBlock().isSolid()) continue;
                teleportLoc.subtract(0.0, (double)i, 0.0);
                break;
            }
        }
        Vector lookDirection = targetLoc.toVector().subtract(teleportLoc.toVector()).normalize();
        teleportLoc.setDirection(lookDirection);
        Location originalLoc = attackerLoc.clone();
        originalLoc.getWorld().spawnParticle(Particle.PORTAL, originalLoc.add(0.0, 1.0, 0.0), 20, 0.5, 1.0, 0.5, 0.1);
        attacker.teleport(teleportLoc);
        teleportLoc.getWorld().spawnParticle(Particle.PORTAL, teleportLoc.add(0.0, 1.0, 0.0), 20, 0.5, 1.0, 0.5, 0.1);
        teleportLoc.getWorld().spawnParticle(Particle.SMOKE, teleportLoc, 15, 0.3, 0.5, 0.3, 0.05);
        originalLoc.getWorld().playSound(originalLoc, Sound.ENTITY_ENDERMAN_TELEPORT, 0.8f, 1.2f);
        teleportLoc.getWorld().playSound(teleportLoc, Sound.ENTITY_ENDERMAN_TELEPORT, 0.8f, 0.8f);
        this.cooldowns.put(playerId, currentTime);
        attacker.sendMessage("\u00a75\u26a1 \u00a77Echo Step activated! Teleported behind target!");
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.echo_step.enabled", true);
    }

    public void cleanupCooldowns() {
        long currentTime = System.currentTimeMillis();
        long maxCooldown = 30000L;
        this.cooldowns.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > maxCooldown);
    }
}

