/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.BerserkerEnchant;
import com.yourname.customenchants.enchants.BlindingEnchant;
import com.yourname.customenchants.enchants.BloodthirstEnchant;
import com.yourname.customenchants.enchants.BulwarkEnchant;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.DashEnchant;
import com.yourname.customenchants.enchants.DisarmEnchant;
import com.yourname.customenchants.enchants.EchoStepEnchant;
import com.yourname.customenchants.enchants.EmberWardEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import com.yourname.customenchants.enchants.ExplodeEnchant;
import com.yourname.customenchants.enchants.ExplosiveArrowEnchant;
import com.yourname.customenchants.enchants.FreezeEnchant;
import com.yourname.customenchants.enchants.GravityWellEnchant;
import com.yourname.customenchants.enchants.LifestealEnchant;
import com.yourname.customenchants.enchants.LightningStrikeEnchant;
import com.yourname.customenchants.enchants.MindSpikeEnchant;
import com.yourname.customenchants.enchants.PhantomStepEnchant;
import com.yourname.customenchants.enchants.PiercingEnchant;
import com.yourname.customenchants.enchants.PoisonBladeEnchant;
import com.yourname.customenchants.enchants.ShieldBreakerEnchant;
import com.yourname.customenchants.enchants.SonicBoomEnchant;
import com.yourname.customenchants.enchants.SoulSiphonEnchant;
import com.yourname.customenchants.enchants.SoulguardEnchant;
import com.yourname.customenchants.enchants.SunflareEnchant;
import com.yourname.customenchants.enchants.ThornsAuraEnchant;
import com.yourname.customenchants.enchants.VengefulStrikeEnchant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class EnchantmentManager {
    private final CustomEnchants plugin;
    private final Map<String, CustomEnchant> enchantments;

    public EnchantmentManager(CustomEnchants plugin) {
        this.plugin = plugin;
        this.enchantments = new HashMap<String, CustomEnchant>();
        this.loadEnchantments();
    }

    private void loadEnchantments() {
        this.registerEnchantment(new LifestealEnchant());
        this.registerEnchantment(new ExplodeEnchant());
        this.registerEnchantment(new PoisonBladeEnchant());
        this.registerEnchantment(new FreezeEnchant());
        this.registerEnchantment(new BlindingEnchant());
        this.registerEnchantment(new LightningStrikeEnchant());
        this.registerEnchantment(new BerserkerEnchant());
        this.registerEnchantment(new ExplosiveArrowEnchant());
        this.registerEnchantment(new ThornsAuraEnchant());
        this.registerEnchantment(new SoulSiphonEnchant());
        this.registerEnchantment(new DisarmEnchant());
        this.registerEnchantment(new PiercingEnchant());
        this.registerEnchantment(new ShieldBreakerEnchant());
        this.registerEnchantment(new BloodthirstEnchant());
        this.registerEnchantment(new SunflareEnchant());
        this.registerEnchantment(new EchoStepEnchant());
        this.registerEnchantment(new SoulguardEnchant());
        this.registerEnchantment(new GravityWellEnchant());
        this.registerEnchantment(new MindSpikeEnchant());
        this.registerEnchantment(new SonicBoomEnchant());
        this.registerEnchantment(new DashEnchant());
        this.registerEnchantment(new VengefulStrikeEnchant());
        this.registerEnchantment(new PhantomStepEnchant());
        this.registerEnchantment(new BulwarkEnchant());
        this.registerEnchantment(new EmberWardEnchant());
    }

    private void registerEnchantment(CustomEnchant enchant) {
        this.enchantments.put(enchant.getKey(), enchant);
    }

    public CustomEnchant getEnchantment(String key) {
        return this.enchantments.get(key);
    }

    public Set<String> getEnchantmentKeys() {
        return this.enchantments.keySet();
    }

    public Map<String, CustomEnchant> getAllEnchantments() {
        return new HashMap<String, CustomEnchant>(this.enchantments);
    }

    public boolean hasCustomEnchantment(ItemStack item, String enchantKey) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, enchantKey);
        return meta.getPersistentDataContainer().has(key, PersistentDataType.INTEGER);
    }

    public int getEnchantmentLevel(ItemStack item, String enchantKey) {
        if (!this.hasCustomEnchantment(item, enchantKey)) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, enchantKey);
        Integer value = (Integer)meta.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
        return value != null ? value : 0;
    }

    public void addEnchantment(ItemStack item, String enchantKey, int level) {
        if (item == null || !this.enchantments.containsKey(enchantKey)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, enchantKey);
        meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)level);
        this.updateItemLore(item, meta);
        item.setItemMeta(meta);
    }

    public void removeEnchantment(ItemStack item, String enchantKey) {
        if (item == null || !this.hasCustomEnchantment(item, enchantKey)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, enchantKey);
        meta.getPersistentDataContainer().remove(key);
        this.updateItemLore(item, meta);
        item.setItemMeta(meta);
    }

    private void updateItemLore(ItemStack item, ItemMeta meta) {
        ArrayList<Object> lore = new ArrayList<Object>();
        if (meta.hasLore()) {
            for (String line : meta.getLore()) {
                if (this.isCustomEnchantmentLore(line)) continue;
                lore.add(line);
            }
        }
        for (String enchantKey : this.enchantments.keySet()) {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, enchantKey);
            if (!meta.getPersistentDataContainer().has(key, PersistentDataType.INTEGER)) continue;
            int level = (Integer)meta.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
            CustomEnchant enchant = this.enchantments.get(enchantKey);
            String rarityColor = this.getRarityColor(enchant.getRarity());
            String levelStr = this.getRomanNumeral(level);
            lore.add(rarityColor + enchant.getDisplayName() + " " + levelStr + " \u00a77(\u00a7" + this.getRarityColorCode(enchant.getRarity()) + enchant.getRarity().name() + "\u00a77)");
        }
        meta.setLore(lore);
    }

    private boolean isCustomEnchantmentLore(String line) {
        String stripped = ChatColor.stripColor((String)line);
        for (CustomEnchant enchant : this.enchantments.values()) {
            if (!stripped.contains(enchant.getDisplayName())) continue;
            return true;
        }
        return false;
    }

    public ItemStack createEnchantedBook(String enchantKey, int level) {
        if (!this.enchantments.containsKey(enchantKey)) {
            return null;
        }
        CustomEnchant enchant = this.enchantments.get(enchantKey);
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta meta = book.getItemMeta();
        String rarityColor = this.getRarityColor(enchant.getRarity());
        String levelStr = this.getRomanNumeral(level);
        meta.setDisplayName(rarityColor + "Enchanted Book");
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(rarityColor + enchant.getDisplayName() + " " + levelStr);
        lore.add("\u00a77" + enchant.getDescription());
        lore.add("\u00a77Rarity: \u00a7" + this.getRarityColorCode(enchant.getRarity()) + enchant.getRarity().name());
        lore.add("");
        lore.add("\u00a77Use in anvil to apply to weapons");
        meta.setLore(lore);
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, enchantKey);
        meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)level);
        book.setItemMeta(meta);
        return book;
    }

    public Map<String, Integer> getCustomEnchantments(ItemStack item) {
        HashMap<String, Integer> enchants = new HashMap<String, Integer>();
        if (item == null || !item.hasItemMeta()) {
            return enchants;
        }
        ItemMeta meta = item.getItemMeta();
        for (String enchantKey : this.enchantments.keySet()) {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, enchantKey);
            if (!meta.getPersistentDataContainer().has(key, PersistentDataType.INTEGER)) continue;
            int level = (Integer)meta.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
            enchants.put(enchantKey, level);
        }
        return enchants;
    }

    private String getRarityColor(EnchantRarity rarity) {
        switch (rarity) {
            case COMMON: {
                return "\u00a7f";
            }
            case RARE: {
                return "\u00a79";
            }
            case EPIC: {
                return "\u00a7d";
            }
            case LEGENDARY: {
                return "\u00a76";
            }
        }
        return "\u00a77";
    }

    private String getRarityColorCode(EnchantRarity rarity) {
        switch (rarity) {
            case COMMON: {
                return "f";
            }
            case RARE: {
                return "9";
            }
            case EPIC: {
                return "d";
            }
            case LEGENDARY: {
                return "6";
            }
        }
        return "7";
    }

    private String getRomanNumeral(int number) {
        switch (number) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
        }
        return String.valueOf(number);
    }
}

