/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class LifestealEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "lifesteal";
    }

    @Override
    public String getDisplayName() {
        return "Lifesteal";
    }

    @Override
    public String getDescription() {
        return "Heals you for a portion of damage dealt";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.EPIC;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        if (target.getLastDamageCause() instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent event = (EntityDamageByEntityEvent)target.getLastDamageCause();
            double damage = event.getFinalDamage();
            double healPercentage = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.lifesteal.heal-percentage-per-level", 0.15);
            double healAmount = damage * (healPercentage * (double)level);
            double currentHealth = attacker.getHealth();
            double maxHealth = attacker.getMaxHealth();
            double newHealth = Math.min(currentHealth + healAmount, maxHealth);
            attacker.setHealth(newHealth);
            attacker.sendMessage("\u00a7c\u2764 \u00a77Healed for \u00a7c" + String.format("%.1f", healAmount) + " \u00a77health!");
        }
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.lifesteal.enabled", true);
    }
}

