/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PhantomStepEnchant
extends CustomEnchant {
    private final Map<UUID, Long> crouchStartTime = new HashMap<UUID, Long>();
    private final Map<UUID, Long> lastActivation = new HashMap<UUID, Long>();

    @Override
    public String getKey() {
        return "phantom_step";
    }

    @Override
    public String getDisplayName() {
        return "Phantom Step";
    }

    @Override
    public String getDescription() {
        return "Grants invisibility for 2-6 seconds after crouching for 1 second";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.RARE;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
        if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
            player.sendMessage("\u00a77Phantom Step broken by damage!");
        }
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    public void onPlayerToggleSneak(PlayerToggleSneakEvent event, Player player, int level) {
        long timeSinceLastUse;
        if (!this.isEnabled()) {
            return;
        }
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        int cooldownSeconds = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.phantom_step.cooldown", 30);
        if (this.lastActivation.containsKey(playerId) && (timeSinceLastUse = currentTime - this.lastActivation.get(playerId)) < (long)(cooldownSeconds * 1000)) {
            long remainingCooldown = ((long)(cooldownSeconds * 1000) - timeSinceLastUse) / 1000L;
            player.sendMessage("\u00a77Phantom Step on cooldown for " + remainingCooldown + " seconds");
            return;
        }
        if (event.isSneaking()) {
            this.crouchStartTime.put(playerId, currentTime);
        } else if (this.crouchStartTime.containsKey(playerId)) {
            long requiredCrouchTime;
            long crouchDuration = currentTime - this.crouchStartTime.get(playerId);
            if (crouchDuration >= (requiredCrouchTime = CustomEnchants.getInstance().getConfigManager().getLong("enchantments.phantom_step.crouch-time", 1000L))) {
                this.activatePhantomStep(player, level);
                this.lastActivation.put(playerId, currentTime);
            }
            this.crouchStartTime.remove(playerId);
        }
    }

    private void activatePhantomStep(final Player player, int level) {
        int baseDuration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.phantom_step.base-duration", 40);
        int durationPerLevel = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.phantom_step.duration-per-level", 40);
        int totalDuration = baseDuration + durationPerLevel * (level - 1);
        PotionEffect invisibility = new PotionEffect(PotionEffectType.INVISIBILITY, totalDuration, 0, false, false);
        player.addPotionEffect(invisibility);
        player.getWorld().spawnParticle(Particle.PORTAL, player.getLocation().add(0.0, 1.0, 0.0), 20, 0.5, 1.0, 0.5, 0.1);
        player.getWorld().spawnParticle(Particle.SMOKE, player.getLocation(), 15, 0.3, 0.1, 0.3, 0.05);
        player.sendMessage("\u00a75\u2726 \u00a77You fade into the shadows...");
        new BukkitRunnable(this){

            public void run() {
                if (player.isOnline() && player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                    player.sendMessage("\u00a77Phantom Step fading...");
                }
            }
        }.runTaskLater((Plugin)CustomEnchants.getInstance(), (long)(totalDuration - 40));
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.phantom_step.enabled", true);
    }
}

