/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class VengefulStrikeEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "vengeful_strike";
    }

    @Override
    public String getDisplayName() {
        return "Vengeful Strike";
    }

    @Override
    public String getDescription() {
        return "Increases damage by 15% per level when health is below 50%";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.EPIC;
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        double threshold;
        if (!this.isEnabled()) {
            return;
        }
        double healthPercent = attacker.getHealth() / attacker.getMaxHealth();
        if (healthPercent <= (threshold = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.vengeful_strike.health-threshold", 0.5))) {
            double baseDamageBonus = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.vengeful_strike.damage-per-level", 0.15);
            double damageMultiplier = 1.0 + baseDamageBonus * (double)level;
            double missingHealthBonus = (1.0 - healthPercent) * 0.5;
            damageMultiplier += missingHealthBonus;
            if (target instanceof LivingEntity) {
                attacker.getWorld().spawnParticle(Particle.DAMAGE_INDICATOR, target.getLocation().add(0.0, 1.0, 0.0), 8, 0.3, 0.3, 0.3, 0.1);
                attacker.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, attacker.getLocation().add(0.0, 1.0, 0.0), 3, 0.2, 0.2, 0.2, 0.05);
                attacker.setMetadata("vengeful_strike_multiplier", (MetadataValue)new FixedMetadataValue((Plugin)CustomEnchants.getInstance(), (Object)damageMultiplier));
            }
        }
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.vengeful_strike.enabled", true);
    }
}

