/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.utils;

import com.yourname.customenchants.CustomEnchants;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final CustomEnchants plugin;
    private FileConfiguration config;

    public ConfigManager(CustomEnchants plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.config.options().copyDefaults(true);
        this.setDefaults();
        this.plugin.saveConfig();
    }

    private void setDefaults() {
        this.config.addDefault("enchantments.allow-stacking", (Object)true);
        this.config.addDefault("enchantments.anvil-base-cost", (Object)5);
        this.config.addDefault("enchantments.anvil-cost-per-level", (Object)2);
        this.config.addDefault("enchantments.anvil-rarity-multiplier", (Object)1);
        this.config.addDefault("debug", (Object)true);
        this.config.addDefault("enchantments.lifesteal.enabled", (Object)true);
        this.config.addDefault("enchantments.lifesteal.rarity", (Object)"epic");
        this.config.addDefault("enchantments.lifesteal.max-level", (Object)3);
        this.config.addDefault("enchantments.lifesteal.heal-percentage.1", (Object)0.05);
        this.config.addDefault("enchantments.lifesteal.heal-percentage.2", (Object)0.1);
        this.config.addDefault("enchantments.lifesteal.heal-percentage.3", (Object)0.15);
        this.config.addDefault("enchantments.explode.enabled", (Object)true);
        this.config.addDefault("enchantments.explode.rarity", (Object)"legendary");
        this.config.addDefault("enchantments.explode.max-level", (Object)2);
        this.config.addDefault("enchantments.explode.explosion-power.1", (Object)1.5);
        this.config.addDefault("enchantments.explode.explosion-power.2", (Object)2.0);
        this.config.addDefault("enchantments.explode.chance-to-trigger.1", (Object)0.2);
        this.config.addDefault("enchantments.explode.chance-to-trigger.2", (Object)0.3);
        this.config.addDefault("enchantments.vengeful_strike.enabled", (Object)true);
        this.config.addDefault("enchantments.vengeful_strike.rarity", (Object)"epic");
        this.config.addDefault("enchantments.vengeful_strike.max-level", (Object)5);
        this.config.addDefault("enchantments.vengeful_strike.damage-per-level", (Object)0.15);
        this.config.addDefault("enchantments.vengeful_strike.health-threshold", (Object)0.5);
        this.config.addDefault("enchantments.phantom_step.enabled", (Object)true);
        this.config.addDefault("enchantments.phantom_step.rarity", (Object)"rare");
        this.config.addDefault("enchantments.phantom_step.max-level", (Object)3);
        this.config.addDefault("enchantments.phantom_step.base-duration", (Object)40);
        this.config.addDefault("enchantments.phantom_step.duration-per-level", (Object)40);
        this.config.addDefault("enchantments.phantom_step.crouch-time", (Object)1000);
        this.config.addDefault("enchantments.phantom_step.cooldown", (Object)30);
        this.config.addDefault("enchantments.bulwark.enabled", (Object)true);
        this.config.addDefault("enchantments.bulwark.rarity", (Object)"legendary");
        this.config.addDefault("enchantments.bulwark.max-level", (Object)4);
        this.config.addDefault("enchantments.bulwark.base-cooldown", (Object)10);
        this.config.addDefault("enchantments.bulwark.cooldown-reduction-per-level", (Object)1);
        this.config.addDefault("enchantments.ember_ward.enabled", (Object)true);
        this.config.addDefault("enchantments.ember_ward.rarity", (Object)"epic");
        this.config.addDefault("enchantments.ember_ward.max-level", (Object)3);
        this.config.addDefault("enchantments.ember_ward.base-healing-percent", (Object)0.5);
        this.config.addDefault("enchantments.ember_ward.healing-per-level", (Object)0.5);
        this.config.addDefault("enchantments.poison_blade.enabled", (Object)true);
        this.config.addDefault("enchantments.poison_blade.rarity", (Object)"rare");
        this.config.addDefault("enchantments.poison_blade.max-level", (Object)3);
        this.config.addDefault("enchantments.poison_blade.poison-duration-seconds.1", (Object)3);
        this.config.addDefault("enchantments.poison_blade.poison-duration-seconds.2", (Object)5);
        this.config.addDefault("enchantments.poison_blade.poison-duration-seconds.3", (Object)7);
        this.config.addDefault("enchantments.poison_blade.chance-to-trigger.1", (Object)0.3);
        this.config.addDefault("enchantments.poison_blade.chance-to-trigger.2", (Object)0.4);
        this.config.addDefault("enchantments.poison_blade.chance-to-trigger.3", (Object)0.5);
        this.config.addDefault("enchantments.freeze.enabled", (Object)true);
        this.config.addDefault("enchantments.freeze.rarity", (Object)"epic");
        this.config.addDefault("enchantments.freeze.max-level", (Object)2);
        this.config.addDefault("enchantments.freeze.slowness-duration-seconds.1", (Object)2);
        this.config.addDefault("enchantments.freeze.slowness-duration-seconds.2", (Object)4);
        this.config.addDefault("enchantments.freeze.slowness-level.1", (Object)1);
        this.config.addDefault("enchantments.freeze.slowness-level.2", (Object)2);
        this.config.addDefault("enchantments.freeze.chance-to-trigger.1", (Object)0.25);
        this.config.addDefault("enchantments.freeze.chance-to-trigger.2", (Object)0.4);
        this.config.addDefault("enchantments.blinding.enabled", (Object)true);
        this.config.addDefault("enchantments.blinding.rarity", (Object)"rare");
        this.config.addDefault("enchantments.blinding.max-level", (Object)2);
        this.config.addDefault("enchantments.blinding.blindness-duration-seconds.1", (Object)3);
        this.config.addDefault("enchantments.blinding.blindness-duration-seconds.2", (Object)5);
        this.config.addDefault("enchantments.blinding.chance-to-trigger.1", (Object)0.25);
        this.config.addDefault("enchantments.blinding.chance-to-trigger.2", (Object)0.4);
        this.config.addDefault("enchantments.lightning_strike.enabled", (Object)true);
        this.config.addDefault("enchantments.lightning_strike.rarity", (Object)"epic");
        this.config.addDefault("enchantments.lightning_strike.max-level", (Object)1);
        this.config.addDefault("enchantments.lightning_strike.chance-to-trigger.1", (Object)0.2);
        this.config.addDefault("enchantments.berserker.enabled", (Object)true);
        this.config.addDefault("enchantments.berserker.rarity", (Object)"rare");
        this.config.addDefault("enchantments.berserker.max-level", (Object)2);
        this.config.addDefault("enchantments.berserker.damage-boost.1", (Object)1.2);
        this.config.addDefault("enchantments.berserker.damage-boost.2", (Object)1.5);
        this.config.addDefault("enchantments.berserker.trigger-on-low-health", (Object)true);
        this.config.addDefault("enchantments.berserker.health-threshold", (Object)0.3);
        this.config.addDefault("enchantments.explosive_arrow.enabled", (Object)true);
        this.config.addDefault("enchantments.explosive_arrow.rarity", (Object)"rare");
        this.config.addDefault("enchantments.explosive_arrow.max-level", (Object)1);
        this.config.addDefault("enchantments.explosive_arrow.explosion-power", (Object)2.0);
        this.config.addDefault("enchantments.explosive_arrow.chance-to-trigger.1", (Object)0.5);
        this.config.addDefault("enchantments.thorns_aura.enabled", (Object)true);
        this.config.addDefault("enchantments.thorns_aura.rarity", (Object)"rare");
        this.config.addDefault("enchantments.thorns_aura.max-level", (Object)2);
        this.config.addDefault("enchantments.thorns_aura.return-damage.1", (Object)2);
        this.config.addDefault("enchantments.thorns_aura.return-damage.2", (Object)4);
        this.config.addDefault("enchantments.thorns_aura.chance-to-trigger.1", (Object)0.2);
        this.config.addDefault("enchantments.thorns_aura.chance-to-trigger.2", (Object)0.35);
        this.config.addDefault("enchantments.soul_siphon.enabled", (Object)true);
        this.config.addDefault("enchantments.soul_siphon.rarity", (Object)"mythic");
        this.config.addDefault("enchantments.soul_siphon.max-level", (Object)3);
        this.config.addDefault("enchantments.soul_siphon.damage-multiplier", (Object)0.5);
        this.config.addDefault("enchantments.disarm.enabled", (Object)true);
        this.config.addDefault("enchantments.disarm.rarity", (Object)"mythic");
        this.config.addDefault("enchantments.disarm.max-level", (Object)2);
        this.config.addDefault("enchantments.disarm.chance-to-disarm.1", (Object)0.2);
        this.config.addDefault("enchantments.disarm.chance-to-disarm.2", (Object)0.35);
        this.config.addDefault("enchantments.disarm.disarm-duration-ticks", (Object)60);
        this.config.addDefault("enchantments.piercing.enabled", (Object)true);
        this.config.addDefault("enchantments.piercing.rarity", (Object)"legendary");
        this.config.addDefault("enchantments.piercing.max-level", (Object)3);
        this.config.addDefault("enchantments.piercing.armor-penetration-percent.1", (Object)0.15);
        this.config.addDefault("enchantments.piercing.armor-penetration-percent.2", (Object)0.3);
        this.config.addDefault("enchantments.piercing.armor-penetration-percent.3", (Object)0.5);
        this.config.addDefault("enchantments.shield_breaker.enabled", (Object)true);
        this.config.addDefault("enchantments.shield_breaker.rarity", (Object)"epic");
        this.config.addDefault("enchantments.shield_breaker.max-level", (Object)2);
        this.config.addDefault("enchantments.shield_breaker.chance-to-disable.1", (Object)0.2);
        this.config.addDefault("enchantments.shield_breaker.chance-to-disable.2", (Object)0.35);
        this.config.addDefault("enchantments.shield_breaker.disable-duration-ticks", (Object)60);
        this.config.addDefault("enchantments.bloodthirst.enabled", (Object)true);
        this.config.addDefault("enchantments.bloodthirst.rarity", (Object)"legendary");
        this.config.addDefault("enchantments.bloodthirst.max-level", (Object)3);
        this.config.addDefault("enchantments.bloodthirst.health-regen-per-damage", (Object)0.2);
        this.config.addDefault("enchantments.bloodthirst.regen-duration-ticks", (Object)100);
        this.config.addDefault("enchantments.sunflare.enabled", (Object)true);
        this.config.addDefault("enchantments.sunflare.rarity", (Object)"epic");
        this.config.addDefault("enchantments.sunflare.max-level", (Object)1);
        this.config.addDefault("enchantments.sunflare.chance-to-trigger.1", (Object)0.15);
        this.config.addDefault("enchantments.echo_step.enabled", (Object)true);
        this.config.addDefault("enchantments.echo_step.rarity", (Object)"rare");
        this.config.addDefault("enchantments.echo_step.max-level", (Object)1);
        this.config.addDefault("enchantments.echo_step.teleport-distance", (Object)5);
        this.config.addDefault("enchantments.soulguard.enabled", (Object)true);
        this.config.addDefault("enchantments.soulguard.rarity", (Object)"mythic");
        this.config.addDefault("enchantments.soulguard.max-level", (Object)1);
        this.config.addDefault("enchantments.soulguard.shield-health-percent", (Object)0.25);
        this.config.addDefault("enchantments.gravity_well.enabled", (Object)true);
        this.config.addDefault("enchantments.gravity_well.rarity", (Object)"legendary");
        this.config.addDefault("enchantments.gravity_well.max-level", (Object)1);
        this.config.addDefault("enchantments.gravity_well.pull-radius", (Object)5);
        this.config.addDefault("enchantments.gravity_well.slow-duration-ticks", (Object)40);
        this.config.addDefault("enchantments.mind_spike.enabled", (Object)true);
        this.config.addDefault("enchantments.mind_spike.rarity", (Object)"mythic");
        this.config.addDefault("enchantments.mind_spike.max-level", (Object)1);
        this.config.addDefault("enchantments.mind_spike.confusion-duration-ticks", (Object)80);
        this.config.addDefault("enchantments.sonic_boom.enabled", (Object)true);
        this.config.addDefault("enchantments.sonic_boom.rarity", (Object)"legendary");
        this.config.addDefault("enchantments.sonic_boom.max-level", (Object)1);
        this.config.addDefault("enchantments.sonic_boom.damage", (Object)6);
        this.config.addDefault("enchantments.sonic_boom.knockback-strength", (Object)2);
        this.config.addDefault("enchantments.dash.enabled", (Object)true);
        this.config.addDefault("enchantments.dash.cooldown-seconds", (Object)5);
        this.config.addDefault("enchantments.dash.base-distance", (Object)5.0);
        this.config.addDefault("enchantments.dash.distance-per-level", (Object)2.0);
        this.config.addDefault("enchantments.dash.bonus-damage-per-level", (Object)1.5);
        this.config.addDefault("loot.enabled", (Object)true);
        this.config.addDefault("loot.drop-chance-percentage", (Object)5.0);
        this.config.addDefault("loot.rarity-weights.common", (Object)50);
        this.config.addDefault("loot.rarity-weights.rare", (Object)30);
        this.config.addDefault("loot.rarity-weights.epic", (Object)15);
        this.config.addDefault("loot.rarity-weights.legendary", (Object)5);
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(path, defaultValue);
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    public double getDouble(String path, double defaultValue) {
        return this.config.getDouble(path, defaultValue);
    }

    public String getString(String path, String defaultValue) {
        return this.config.getString(path, defaultValue);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public long getLong(String path, long defaultValue) {
        if (this.config.contains(path)) {
            try {
                return this.config.getLong(path);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

