/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants;

import com.yourname.customenchants.commands.CustomEnchantsCommand;
import com.yourname.customenchants.enchants.EnchantmentManager;
import com.yourname.customenchants.listeners.AnvilListener;
import com.yourname.customenchants.listeners.CombatListener;
import com.yourname.customenchants.listeners.EnchantmentTableListener;
import com.yourname.customenchants.utils.ConfigManager;
import com.yourname.customenchants.utils.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomEnchants
extends JavaPlugin {
    private static CustomEnchants instance;
    private EnchantmentManager enchantmentManager;
    private ConfigManager configManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.enchantmentManager = new EnchantmentManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new CombatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AnvilListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EnchantmentTableListener(this), (Plugin)this);
        this.getCommand("customenchants").setExecutor((CommandExecutor)new CustomEnchantsCommand(this));
        this.getCommand("ce").setExecutor((CommandExecutor)new CustomEnchantsCommand(this));
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderHook(this).register();
            this.getLogger().info("PlaceholderAPI integration enabled!");
        }
        this.getLogger().info("CustomEnchants has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("CustomEnchants has been disabled!");
    }

    public static CustomEnchants getInstance() {
        return instance;
    }

    public EnchantmentManager getEnchantmentManager() {
        return this.enchantmentManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void debug(String msg) {
        if (this.getConfig().getBoolean("debug", false)) {
            this.getLogger().info("[DEBUG] " + msg);
        }
    }
}

