/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BerserkerEnchant
extends CustomEnchant {
    @Override
    public String getKey() {
        return "berserker";
    }

    @Override
    public String getDisplayName() {
        return "Berserker";
    }

    @Override
    public String getDescription() {
        return "Gain strength when your health is low";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.RARE;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
        double threshold;
        if (!this.isEnabled()) {
            return;
        }
        double healthPercent = player.getHealth() / player.getMaxHealth();
        if (healthPercent <= (threshold = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.berserker.health-threshold", 0.3))) {
            int strengthLevel = level - 1;
            int duration = 200;
            PotionEffect strength = new PotionEffect(PotionEffectType.STRENGTH, duration, strengthLevel, false, true);
            PotionEffect speed = new PotionEffect(PotionEffectType.SPEED, duration, 0, false, true);
            player.addPotionEffect(strength);
            player.addPotionEffect(speed);
            player.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, player.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 0.5, 0.5, 0.1);
            player.sendMessage("\u00a7c\u2694 \u00a77Berserker rage activated!");
        }
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.berserker.enabled", true);
    }
}

