/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.Random;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ShieldBreakerEnchant
extends CustomEnchant {
    private Random random = new Random();

    @Override
    public String getKey() {
        return "shield_breaker";
    }

    @Override
    public String getDisplayName() {
        return "Shield Breaker";
    }

    @Override
    public String getDescription() {
        return "Chance to temporarily disable enemy shields or block";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.EPIC;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        PlayerInventory inv;
        ItemStack offHand;
        if (!this.isEnabled() || !(target instanceof Player)) {
            return;
        }
        final Player targetPlayer = (Player)target;
        double chancePerLevel = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.shield_breaker.chance-per-level", 0.2);
        double chance = chancePerLevel * (double)level;
        if (this.random.nextDouble() < chance && (offHand = (inv = targetPlayer.getInventory()).getItemInOffHand()) != null && offHand.getType().name().contains("SHIELD")) {
            final ItemStack shieldCopy = offHand.clone();
            inv.setItemInOffHand(null);
            targetPlayer.sendMessage("\u00a7c\ud83d\udee1 \u00a77Your shield has been broken!");
            attacker.sendMessage("\u00a76\ud83d\udee1 \u00a77Shield Breaker activated!");
            int disableDuration = CustomEnchants.getInstance().getConfigManager().getInt("enchantments.shield_breaker.disable-duration-ticks", 100);
            new BukkitRunnable(this){

                public void run() {
                    if (targetPlayer.isOnline()) {
                        targetPlayer.getInventory().setItemInOffHand(shieldCopy);
                        targetPlayer.sendMessage("\u00a7a\ud83d\udee1 \u00a77Your shield has been restored!");
                    }
                }
            }.runTaskLater((Plugin)CustomEnchants.getInstance(), (long)disableDuration);
        }
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.shield_breaker.enabled", true);
    }
}

