/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SonicBoomEnchant
extends CustomEnchant {
    private final Random random = new Random();

    @Override
    public String getKey() {
        return "sonic_boom";
    }

    @Override
    public String getDisplayName() {
        return "Sonic Boom";
    }

    @Override
    public String getDescription() {
        return "Creates a shockwave on critical hits, damaging and knocking back enemies in a line";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.LEGENDARY;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
        if (!this.isEnabled()) {
            return;
        }
        double critChance = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.sonic_boom.crit-chance-per-level", 0.2) * (double)level;
        if (this.random.nextDouble() > critChance) {
            return;
        }
        Location attackerLoc = attacker.getLocation();
        Location targetLoc = target.getLocation();
        double shockwaveLength = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.sonic_boom.length-per-level", 8.0) * (double)level;
        double shockwaveWidth = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.sonic_boom.width", 3.0);
        double damage = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.sonic_boom.damage-per-level", 2.0) * (double)level;
        double knockbackStrength = CustomEnchants.getInstance().getConfigManager().getDouble("enchantments.sonic_boom.knockback-per-level", 1.5) * (double)level;
        Vector direction = targetLoc.toVector().subtract(attackerLoc.toVector()).normalize();
        this.createSonicShockwave(attackerLoc, direction, shockwaveLength, shockwaveWidth, damage, knockbackStrength, attacker);
        attacker.sendMessage("\u00a7b\u26a1 \u00a77Sonic Boom unleashed!");
    }

    private void createSonicShockwave(final Location origin, final Vector direction, final double length, final double width, final double damage, final double knockbackStrength, final Player attacker) {
        final ArrayList hitEntities = new ArrayList();
        new BukkitRunnable(this){
            double currentDistance = 0.0;
            final double stepSize = 0.5;
            final int maxSteps = (int)(length / 0.5);
            int currentStep = 0;
            final /* synthetic */ SonicBoomEnchant this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.currentStep >= this.maxSteps) {
                    this.cancel();
                    return;
                }
                Location currentLoc = origin.clone().add(direction.clone().multiply(this.currentDistance));
                this.this$0.createShockwaveVisuals(currentLoc, direction, width);
                for (LivingEntity entity : currentLoc.getWorld().getLivingEntities()) {
                    Location entityLoc;
                    if (entity == attacker || hitEntities.contains(entity) || entity.isDead() || entity instanceof Player && !currentLoc.getWorld().getPVP() || !this.this$0.isInShockwaveArea(currentLoc, entityLoc = entity.getLocation(), direction, width)) continue;
                    hitEntities.add(entity);
                    entity.damage(damage, (Entity)attacker);
                    Vector knockback = direction.clone().multiply(knockbackStrength);
                    knockback.setY(Math.max(knockback.getY(), 0.3));
                    entity.setVelocity(entity.getVelocity().add(knockback));
                    entityLoc.getWorld().spawnParticle(Particle.EXPLOSION, entityLoc.add(0.0, 1.0, 0.0), 3, 0.3, 0.3, 0.3, 0.1);
                    entityLoc.getWorld().spawnParticle(Particle.SWEEP_ATTACK, entityLoc, 5, 0.5, 0.5, 0.5, 0.1);
                }
                this.currentDistance += 0.5;
                ++this.currentStep;
            }
        }.runTaskTimer((Plugin)CustomEnchants.getInstance(), 0L, 1L);
        origin.getWorld().playSound(origin, Sound.ENTITY_WARDEN_SONIC_BOOM, 1.0f, 1.0f);
        origin.getWorld().playSound(origin, Sound.ENTITY_GENERIC_EXPLODE, 0.7f, 0.8f);
    }

    private void createShockwaveVisuals(Location center, Vector direction, double width) {
        center.getWorld().spawnParticle(Particle.SWEEP_ATTACK, center, 3, width / 4.0, 0.2, width / 4.0, 0.1);
        center.getWorld().spawnParticle(Particle.SONIC_BOOM, center.add(0.0, 0.5, 0.0), 2, width / 6.0, 0.3, width / 6.0, 0.05);
        Vector perpendicular = new Vector(-direction.getZ(), 0.0, direction.getX()).normalize();
        for (double side = -width / 2.0; side <= width / 2.0; side += width / 4.0) {
            if (side == 0.0) continue;
            Location sideLoc = center.clone().add(perpendicular.clone().multiply(side));
            sideLoc.getWorld().spawnParticle(Particle.CLOUD, sideLoc, 2, 0.1, 0.1, 0.1, 0.02);
        }
        Location groundLoc = center.clone();
        groundLoc.setY(groundLoc.getY() - 1.0);
        if (groundLoc.getBlock().isSolid()) {
            groundLoc.getWorld().spawnParticle(Particle.BLOCK, groundLoc.add(0.0, 1.0, 0.0), 8, width / 3.0, 0.1, width / 3.0, 0.1, (Object)groundLoc.getBlock().getBlockData());
        }
    }

    private boolean isInShockwaveArea(Location shockwaveLoc, Location entityLoc, Vector direction, double width) {
        Vector toEntity = entityLoc.toVector().subtract(shockwaveLoc.toVector());
        double forwardDistance = toEntity.dot(direction);
        if (forwardDistance < -1.0) {
            return false;
        }
        Vector perpendicularComponent = toEntity.clone().subtract(direction.clone().multiply(forwardDistance));
        double perpendicularDistance = perpendicularComponent.length();
        return perpendicularDistance <= width / 2.0 && forwardDistance <= 2.0;
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.sonic_boom.enabled", true);
    }
}

