/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.enchants;

import com.yourname.customenchants.CustomEnchants;
import com.yourname.customenchants.enchants.CustomEnchant;
import com.yourname.customenchants.enchants.EnchantRarity;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ThornsAuraEnchant
extends CustomEnchant {
    private static final List<Material> ARMOR_TYPES = Arrays.asList(Material.LEATHER_HELMET, Material.CHAINMAIL_HELMET, Material.IRON_HELMET, Material.DIAMOND_HELMET, Material.GOLDEN_HELMET, Material.NETHERITE_HELMET, Material.TURTLE_HELMET, Material.LEATHER_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.IRON_CHESTPLATE, Material.DIAMOND_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.NETHERITE_CHESTPLATE, Material.ELYTRA, Material.LEATHER_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.IRON_LEGGINGS, Material.DIAMOND_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.NETHERITE_LEGGINGS, Material.LEATHER_BOOTS, Material.CHAINMAIL_BOOTS, Material.IRON_BOOTS, Material.DIAMOND_BOOTS, Material.GOLDEN_BOOTS, Material.NETHERITE_BOOTS);

    @Override
    public String getKey() {
        return "thorns_aura";
    }

    @Override
    public String getDisplayName() {
        return "Thorns Aura";
    }

    @Override
    public String getDescription() {
        return "Damage all nearby enemies when you take damage";
    }

    @Override
    public EnchantRarity getRarity() {
        return EnchantRarity.RARE;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event, Player player, int level) {
    }

    @Override
    public void onBlockBreak(BlockBreakEvent event, Player player, int level) {
    }

    @Override
    public void onAttack(Player attacker, LivingEntity target, int level, ItemStack weapon) {
    }

    @Override
    public void onDamageReceived(Player player, EntityDamageEvent event, int level) {
        if (!this.isEnabled()) {
            return;
        }
        int totalLevel = this.getTotalArmorEnchantLevel(player);
        if (totalLevel <= 0) {
            return;
        }
        double radius = 3.0 + (double)totalLevel * 0.5;
        double damage = 1.0 + (double)totalLevel * 0.5;
        int entitiesDamaged = 0;
        for (LivingEntity entity : player.getWorld().getLivingEntities()) {
            if (entity == player || !(entity.getLocation().distance(player.getLocation()) <= radius) || entity.isDead() || entity instanceof Player && !player.getWorld().getPVP()) continue;
            entity.damage(damage);
            ++entitiesDamaged;
            entity.getWorld().spawnParticle(Particle.CRIT, entity.getLocation().add(0.0, 1.0, 0.0), 8, 0.5, 0.5, 0.5, 0.1);
            entity.getWorld().spawnParticle(Particle.DAMAGE_INDICATOR, entity.getLocation().add(0.0, 1.5, 0.0), 3, 0.3, 0.3, 0.3, 0.1);
        }
        if (entitiesDamaged > 0) {
            player.getWorld().spawnParticle(Particle.ENCHANTED_HIT, player.getLocation().add(0.0, 1.0, 0.0), 25, radius / 2.0, 1.0, radius / 2.0, 0.1);
            player.getWorld().spawnParticle(Particle.WITCH, player.getLocation().add(0.0, 1.0, 0.0), 15, radius / 3.0, 0.5, radius / 3.0, 0.05);
            player.playSound(player.getLocation(), Sound.ENCHANT_THORNS_HIT, 1.0f, 0.8f);
            player.sendMessage("\u00a76\u26a1 \u00a77Thorns aura activated! \u00a7c" + entitiesDamaged + " \u00a77enemies damaged!");
        }
    }

    @Override
    public void onProjectileHit(ProjectileHitEvent event, Player shooter, int level) {
    }

    private int getTotalArmorEnchantLevel(Player player) {
        ItemStack[] armorContents;
        PlayerInventory inventory = player.getInventory();
        int totalLevel = 0;
        for (ItemStack armor : armorContents = inventory.getArmorContents()) {
            if (armor == null || !this.isValidArmorType(armor.getType())) continue;
            int enchantLevel = this.getEnchantLevelFromItem(armor);
            totalLevel += enchantLevel;
        }
        return totalLevel;
    }

    private boolean isValidArmorType(Material material) {
        return ARMOR_TYPES.contains(material);
    }

    private int getEnchantLevelFromItem(ItemStack item) {
        return 0;
    }

    public List<Material> getValidArmorTypes() {
        return ARMOR_TYPES;
    }

    public boolean canApplyTo(Material material) {
        return this.isValidArmorType(material);
    }

    @Override
    public boolean isEnabled() {
        return CustomEnchants.getInstance().getConfigManager().getBoolean("enchantments.thorns_aura.enabled", true);
    }
}

