/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.customenchants.utils;

import com.yourname.customenchants.CustomEnchants;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final CustomEnchants plugin;
    private FileConfiguration config;

    public ConfigManager(CustomEnchants plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.config.options().copyDefaults(true);
        this.setDefaults();
        this.plugin.saveConfig();
    }

    private void setDefaults() {
        this.config.addDefault("debug", (Object)true);
        this.config.addDefault("enchantments.allow-stacking", (Object)true);
        this.config.addDefault("enchantments.anvil-base-cost", (Object)5);
        this.config.addDefault("enchantments.anvil-cost-per-level", (Object)2);
        this.config.addDefault("enchantments.anvil-rarity-multiplier", (Object)1);
        this.config.addDefault("enchantments.enable-enchantment-table", (Object)true);
        this.config.addDefault("enchantments.table-additional-cost", (Object)2);
        this.config.addDefault("enchantments.table-custom-chance", (Object)0.15);
        this.config.addDefault("enchantments.table-level-multiplier", (Object)0.02);
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(path, defaultValue);
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    public double getDouble(String path, double defaultValue) {
        return this.config.getDouble(path, defaultValue);
    }

    public String getString(String path, String defaultValue) {
        return this.config.getString(path, defaultValue);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public long getLong(String path, long defaultValue) {
        if (this.config.contains(path)) {
            try {
                return this.config.getLong(path);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

