/*
 * Decompiled with CFR 0.152.
 */
package tobinio.bettersnowcoverage;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2493;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import tobinio.bettersnowcoverage.config.Config;

public class BetterSnowChecker {
    public static class_2680 getSnowState(class_2680 state) {
        if (state.method_26204() instanceof class_2493) {
            return (class_2680)state.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public static SnowState shouldHaveSnowAboveBlock(class_1922 world, class_2338 pos) {
        class_2338 above = pos.method_10084();
        class_2680 state = world.method_8320(above);
        if (state.method_26206(world, above, class_2350.field_11033) || state.method_26164(class_3481.field_51989) || state.method_26204() == class_2246.field_10382) {
            return SnowState.NONE;
        }
        if (!world.method_8320(pos).method_26234(world, pos)) {
            return SnowState.NONE;
        }
        if (BetterSnowChecker.hasSnowNeighbor(world, above)) {
            if (BetterSnowChecker.isExcludedBlock(state)) {
                return SnowState.WITHOUT_LAYER;
            }
            return SnowState.WITH_LAYER;
        }
        return SnowState.NONE;
    }

    private static boolean isExcludedBlock(class_2680 state) {
        for (class_6862<class_2248> tag : Config.EXCLUDED_TAGS) {
            if (!state.method_26164(tag)) continue;
            return true;
        }
        for (class_2248 block : Config.EXCLUDED_BLOCKS) {
            if (!state.method_26204().equals(block)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSnowNeighbor(class_1922 world, class_2338 pos) {
        ArrayList<DirectionChecker> directionCheckers = new ArrayList<DirectionChecker>();
        directionCheckers.add(new DirectionChecker(class_2350.field_11043, pos.method_10074()));
        directionCheckers.add(new DirectionChecker(class_2350.field_11034, pos.method_10074()));
        directionCheckers.add(new DirectionChecker(class_2350.field_11035, pos.method_10074()));
        directionCheckers.add(new DirectionChecker(class_2350.field_11039, pos.method_10074()));
        Config config = (Config)Config.HANDLER.instance();
        int snowCount = 0;
        int noneCount = 0;
        block9: for (int j = 0; j < config.maxHorizontalDistance; ++j) {
            for (int i = directionCheckers.size() - 1; i >= 0; --i) {
                DirectionChecker directionChecker = (DirectionChecker)directionCheckers.get(i);
                Optional<DirectionChecker.Result> result = directionChecker.next(world, config);
                if (result.isEmpty()) continue;
                switch (result.get().ordinal()) {
                    case 0: {
                        ++noneCount;
                        break;
                    }
                    case 1: {
                        ++snowCount;
                    }
                }
                directionCheckers.remove(i);
            }
            if (snowCount == 0 && noneCount == 0) continue;
            switch (config.checkerMode) {
                case PREFER_SNOW: {
                    return snowCount >= noneCount;
                }
                case PREFER_AIR: {
                    return snowCount > noneCount;
                }
                case ALL_SIDES: {
                    if (snowCount != 4) continue block9;
                    return true;
                }
            }
        }
        return false;
    }

    public static enum SnowState {
        NONE,
        WITH_LAYER,
        WITHOUT_LAYER;

    }

    static class DirectionChecker {
        private final class_2350 direction;
        private class_2338 lastPos;

        public DirectionChecker(class_2350 direction, class_2338 pos) {
            this.direction = direction;
            this.lastPos = pos;
        }

        public Optional<Result> next(class_1922 world, Config config) {
            Integer n;
            this.lastPos = this.lastPos.method_10069(this.direction.method_10148(), 0, this.direction.method_10165());
            Integer maxDepth = config.maxVerticalDistance;
            while (!world.method_8320(this.lastPos).method_26234(world, this.lastPos)) {
                n = maxDepth;
                maxDepth = maxDepth - 1;
                if (n <= 0) {
                    return Optional.of(Result.UNDEFINED);
                }
                this.lastPos = this.lastPos.method_10074();
            }
            while (world.method_8320(this.lastPos.method_10084()).method_26234(world, this.lastPos.method_10084())) {
                n = maxDepth;
                maxDepth = maxDepth - 1;
                if (n <= 0) {
                    return Optional.of(Result.UNDEFINED);
                }
                this.lastPos = this.lastPos.method_10084();
            }
            if (world.method_8320(this.lastPos.method_10084()).method_26164(class_3481.field_29823)) {
                return Optional.of(Result.SNOW);
            }
            if (world.method_8320(this.lastPos.method_10084()).method_26164(class_3481.field_51989)) {
                return Optional.of(Result.NONE);
            }
            return Optional.empty();
        }

        static enum Result {
            NONE,
            SNOW,
            UNDEFINED;

        }
    }
}

