/*
 * Decompiled with CFR 0.152.
 */
package tobinio.bettersnowcoverage.config;

import com.google.gson.GsonBuilder;
import com.mojang.text2speech.Narrator;
import dev.isxander.yacl3.api.NameableEnum;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import tobinio.bettersnowcoverage.BetterSnowCoverage;

public class Config {
    public static List<String> DEFAULT_EXCLUDED_BLOCKS = List.of("wildflowers", "pink_petals", "leaf_litter");
    public static List<String> DEFAULT_EXCLUDED_TAGS = List.of("buttons", "pressure_plates", "rails", "leaves");
    public static List<class_2248> EXCLUDED_BLOCKS = new ArrayList<class_2248>();
    public static List<class_6862<class_2248>> EXCLUDED_TAGS = new ArrayList<class_6862<class_2248>>();
    public static ConfigClassHandler<Config> HANDLER = ConfigClassHandler.createBuilder(Config.class).id(BetterSnowCoverage.id("config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FabricLoader.getInstance().getConfigDir().resolve("%s.json5".formatted("better-snow-coverage"))).appendGsonBuilder(GsonBuilder::setPrettyPrinting).setJson5(true).build()).build();
    @SerialEntry
    public List<String> excludedBlocks = new ArrayList<String>(DEFAULT_EXCLUDED_BLOCKS);
    @SerialEntry
    public List<String> excludedTags = new ArrayList<String>(DEFAULT_EXCLUDED_TAGS);
    @SerialEntry
    public Integer maxVerticalDistance = 2;
    @SerialEntry
    public Integer maxHorizontalDistance = 8;
    @SerialEntry
    public CheckerMode checkerMode = CheckerMode.PREFER_SNOW;

    public static void update() {
        Config.setBlocks(((Config)Config.HANDLER.instance()).excludedBlocks, EXCLUDED_BLOCKS);
        Config.setTags(((Config)Config.HANDLER.instance()).excludedTags, EXCLUDED_TAGS);
    }

    private static void setTags(List<String> strings, List<class_6862<class_2248>> tags) {
        tags.clear();
        for (String id : strings) {
            class_2960 identifier = class_2960.method_12829((String)id);
            if (identifier == null) {
                Narrator.LOGGER.error("Could not parse tag id {}", (Object)id);
                continue;
            }
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)identifier);
            tags.add((class_6862<class_2248>)tagKey);
        }
    }

    private static void setBlocks(List<String> strings, List<class_2248> blocks) {
        blocks.clear();
        for (String id : strings) {
            class_2960 identifier = class_2960.method_12829((String)id);
            if (identifier == null) {
                Narrator.LOGGER.error("Could not parse block id {}", (Object)id);
                continue;
            }
            Optional block = class_7923.field_41175.method_17966(identifier);
            if (block.isPresent()) {
                blocks.add((class_2248)block.get());
                continue;
            }
            Narrator.LOGGER.error("Could not find block {}", (Object)id);
        }
    }

    public static enum CheckerMode implements NameableEnum
    {
        PREFER_SNOW,
        PREFER_AIR,
        ALL_SIDES;


        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)"%s.mode.%s".formatted("better-snow-coverage", this.name().toLowerCase()));
        }
    }
}

