/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.f3screenshot;

import builderb0y.f3screenshot.mixins.DebugHudAccessor;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class F3Screenshot
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"F3Screenshot");
    public static final String MISC = "Miscellaneous/un-sorted";

    public void onInitializeClient() {
        System.setProperty("java.awt.headless", "false");
        LOGGER.info("Set java.awt.headless to false.");
        MixinEnvironment.getCurrentEnvironment().audit();
    }

    public static void saveF3(File screenshotsFolder, Consumer<class_2561> messageSender) {
        if (class_310.method_1551().method_1560() == null) {
            return;
        }
        File f3File = F3Screenshot.getSaveFile(screenshotsFolder);
        Throwable saveException = F3Screenshot.saveF3Data(f3File);
        if (saveException == null) {
            Throwable copyException = F3Screenshot.copyFile(f3File);
            if (copyException == null) {
                messageSender.accept((class_2561)class_2561.method_48322((String)"f3screenshot.f3.full_success", (String)"Saved F3 data to %s and copied it to your clipboard.", (Object[])new Object[]{f3File.getName()}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, f3File.getAbsolutePath()))));
            } else {
                messageSender.accept((class_2561)class_2561.method_48322((String)"f3screenshot.f3.partial_success", (String)"Saved F3 data to %s, but could not copy it to your clipboard: %s", (Object[])new Object[]{f3File.getName(), copyException.getLocalizedMessage()}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, f3File.getAbsolutePath()))));
            }
        } else {
            messageSender.accept((class_2561)class_2561.method_48322((String)"f3screenshot.f3.no_success", (String)"Failed to save F3 data to file: %s", (Object[])new Object[]{saveException}));
        }
    }

    public static Throwable saveF3Data(File f3File) {
        Iterator<String> iterator;
        block10: {
            BufferedWriter writer = Files.newBufferedWriter(f3File.toPath(), StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
            try {
                DebugHudAccessor accessor = (DebugHudAccessor)class_310.method_1551().method_53526();
                class_1297 entity = class_310.method_1551().method_1560();
                accessor.f3Screenshot_setBlockHit(entity.method_5745(20.0, 0.0f, false));
                accessor.f3Screenshot_setFluidHit(entity.method_5745(20.0, 0.0f, true));
                writer.write("Left:");
                for (String line : accessor.f3Screenshot_getLeftText()) {
                    writer.append('\n').append('\t').write(line);
                }
                writer.write("\n\nRight:");
                for (String line : accessor.f3Screenshot_getRightText()) {
                    writer.append('\n').append('\t').write(line);
                }
                iterator = null;
                if (writer == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to save F3 data to file:", (Throwable)exception);
                    return exception;
                }
            }
            writer.close();
        }
        return iterator;
    }

    public static File getSaveFile(File screenshotsFolder) {
        String time = class_156.method_44893();
        File file = new File(screenshotsFolder, time + "_F3.txt");
        if (!file.exists()) {
            return file;
        }
        int attempt = 2;
        while ((file = new File(screenshotsFolder, time + "_" + attempt + "_F3.txt")).exists()) {
            ++attempt;
        }
        return file;
    }

    public static Throwable copyFile(final File file) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.javaFileListFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return flavor.equals(DataFlavor.javaFileListFlavor);
                }

                @Override
                @NotNull
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                        return Collections.singletonList(file);
                    }
                    throw new UnsupportedFlavorException(flavor);
                }
            }, (clipboard, contents) -> {});
            return null;
        }
        catch (Exception exception) {
            LOGGER.error("Exception copying F3 data to clipboard.", (Throwable)exception);
            return exception;
        }
    }
}

