/*
 * Decompiled with CFR 0.152.
 */
package uk.co.finleyofthewoods.warpspeed.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.finleyofthewoods.warpspeed.utils.PlayerLocationTracker;
import uk.co.finleyofthewoods.warpspeed.utils.TeleportUtils;

public class BackCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackCommand.class);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"back").executes(BackCommand::execute));
    }

    private static int execute(CommandContext<class_2168> context) {
        try {
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737()) {
                LOGGER.warn("Command executed by non-player");
                source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
                return 0;
            }
            class_3222 player = source.method_9207();
            if (!PlayerLocationTracker.hasPreviousLocation(player)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"No previous location found"), false);
                return 0;
            }
            boolean success = TeleportUtils.teleportToLastLocation(player);
            if (success) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Teleported to previous location"), false);
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"Failed to teleport to previous location"), false);
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected Exception: Failed to execute /back command", (Throwable)e);
            return 0;
        }
    }
}

