/*
 * Decompiled with CFR 0.152.
 */
package uk.co.finleyofthewoods.warpspeed.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.finleyofthewoods.warpspeed.utils.DatabaseManager;
import uk.co.finleyofthewoods.warpspeed.utils.HomePosition;
import uk.co.finleyofthewoods.warpspeed.utils.TeleportUtils;

public class HomeCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(HomeCommand.class);
    private static final int MAX_HOME_PER_PLAYER = 10;

    private static SuggestionProvider<class_2168> homeSuggestions(DatabaseManager dbManager) {
        return (context, builder) -> {
            try {
                class_3222 player = ((class_2168)context.getSource()).method_9207();
                List<HomePosition> homeNames = dbManager.getPlayerHomes(player.method_5667());
                List<String> homeNamesList = homeNames.stream().map(HomePosition::getHomeName).toList();
                return HomeCommand.suggestMatching(homeNamesList, builder);
            }
            catch (CommandSyntaxException e) {
                return Suggestions.empty();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected Exception: Failed to execute /home command", (Throwable)e);
                return Suggestions.empty();
            }
        };
    }

    private static CompletableFuture<Suggestions> suggestMatching(List<String> candidates, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase();
        for (String candidate : candidates) {
            if (!candidate.toLowerCase().startsWith(remaining)) continue;
            builder.suggest(candidate);
        }
        return builder.buildFuture();
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, DatabaseManager dbManager) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"homeName", (ArgumentType)StringArgumentType.word()).suggests(HomeCommand.homeSuggestions(dbManager)).executes(context -> HomeCommand.executeTeleportHome((CommandContext<class_2168>)context, dbManager))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"homes").requires(source -> source.method_44023() != null)).executes(context -> HomeCommand.executeListHomes((CommandContext<class_2168>)context, dbManager)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setHome").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"homeName", (ArgumentType)StringArgumentType.word()).executes(context -> HomeCommand.executeSetHome((CommandContext<class_2168>)context, dbManager))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delHome").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"homeName", (ArgumentType)StringArgumentType.word()).suggests(HomeCommand.homeSuggestions(dbManager)).executes(context -> HomeCommand.executeDeleteHome((CommandContext<class_2168>)context, dbManager))));
    }

    private static int executeTeleportHome(CommandContext<class_2168> context, DatabaseManager dbManager) {
        try {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            String homeName = StringArgumentType.getString(context, (String)"homeName");
            class_3218 world = player.method_51469();
            if (homeName.length() > 32 || !homeName.matches("[a-zA-Z0-9_-]+")) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Home name must be 1-32 alphanumeric characters"), false);
                return 0;
            }
            boolean success = TeleportUtils.teleportToHome(player, (class_1937)world, homeName, dbManager);
            if (success) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Teleported to home: " + homeName)), false);
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)("Failed to teleport to home: " + homeName)), false);
            return 0;
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Failed to execute /home command", (Throwable)e);
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected Exception: Failed to execute /home command", (Throwable)e);
            return 0;
        }
    }

    private static int executeSetHome(CommandContext<class_2168> context, DatabaseManager dbManager) {
        try {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            String homeName = StringArgumentType.getString(context, (String)"homeName");
            boolean homeExists = dbManager.homeExists(player.method_5667(), homeName);
            if (homeExists) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Home '" + homeName + "' already exists")), false);
                return 0;
            }
            int homeCount = dbManager.getHomeCount(player.method_5667());
            if (homeCount >= 10) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You have reached the maximum number of homes (10)"), false);
                return 0;
            }
            class_2338 pos = player.method_24515();
            class_3218 world = player.method_51469();
            String worldId = world.method_27983().method_29177().toString();
            HomePosition home = new HomePosition(player.method_5667(), homeName, worldId, pos.method_10263(), pos.method_10264(), pos.method_10260());
            boolean success = dbManager.saveHome(home);
            if (success) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Home '" + homeName + "' set at " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())), false);
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)("Failed to set home '" + homeName + "'")), false);
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected Exception: Failed to execute /setHome command", (Throwable)e);
            return 0;
        }
    }

    private static int executeDeleteHome(CommandContext<class_2168> context, DatabaseManager dbManager) {
        try {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            String homeName = StringArgumentType.getString(context, (String)"homeName");
            boolean success = dbManager.removeHome(player.method_5667(), homeName);
            if (success) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Home '" + homeName + "' deleted")), false);
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)("Failed to delete home '" + homeName + "'")), false);
            return 0;
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Failed to execute /delHome command", (Throwable)e);
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected Exception: Failed to execute /delHome command", (Throwable)e);
            return 0;
        }
    }

    private static int executeListHomes(CommandContext<class_2168> context, DatabaseManager dbManager) {
        try {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            List<HomePosition> homes = dbManager.getPlayerHomes(player.method_5667());
            if (homes.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You have no homes set"), false);
                return 0;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"Your homes:"), false);
            for (HomePosition home : homes) {
                player.method_7353((class_2561)class_2561.method_43470((String)("    " + home.getHomeName() + " at " + home.getX() + ", " + home.getY() + ", " + home.getZ())), false);
            }
            return 1;
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Failed to execute /deleteWarp command", (Throwable)e);
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected Exception: Failed to execute /deleteWarp command", (Throwable)e);
            return 0;
        }
    }
}

