/*
 * Decompiled with CFR 0.152.
 */
package uk.co.finleyofthewoods.warpspeed.utils;

import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.finleyofthewoods.warpspeed.exceptions.NoSafeLocationFoundException;
import uk.co.finleyofthewoods.warpspeed.utils.DatabaseManager;
import uk.co.finleyofthewoods.warpspeed.utils.HomePosition;
import uk.co.finleyofthewoods.warpspeed.utils.PlayerLocationTracker;
import uk.co.finleyofthewoods.warpspeed.utils.WarpPosition;

public class TeleportUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TeleportUtils.class);

    public static boolean teleportToSpawn(class_3222 player, class_1937 world, class_2338 spawnPos) {
        try {
            LOGGER.debug("Attempting to teleport player {} to spawn at ({}, {}, {})", new Object[]{player.method_5477().toString(), spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260()});
            class_2338 safeLoc = TeleportUtils.findSafeLocation(world, spawnPos);
            return TeleportUtils.teleportPlayer(player, world, safeLoc);
        }
        catch (Exception e) {
            TeleportUtils.handleException(e);
            return false;
        }
    }

    public static boolean teleportToHome(class_3222 player, class_1937 world, String homeName, DatabaseManager dbManager) {
        try {
            HomePosition home = dbManager.getHome(player.method_5667(), homeName);
            if (home == null) {
                LOGGER.warn("Failed to find home for player {}: {}", (Object)player.method_5477().toString(), (Object)homeName);
                return false;
            }
            class_2338 homePos = home.getBlockPos();
            LOGGER.debug("Attempting to teleport {} to ({}, {}, {})", new Object[]{player.method_5477().toString(), homePos.method_10263(), homePos.method_10264(), homePos.method_10260()});
            class_3218 targetWorld = TeleportUtils.getTargetWorld(player, home.getWorldId());
            if (targetWorld == null) {
                LOGGER.warn("Failed to find world {} for warp {}", (Object)home.getWorldId(), (Object)homeName);
                player.method_7353((class_2561)class_2561.method_43470((String)"Failed to teleport: warp world not found"), false);
                return false;
            }
            class_2338 safeLoc = TeleportUtils.findSafeLocation((class_1937)targetWorld, homePos);
            return TeleportUtils.teleportPlayer(player, (class_1937)targetWorld, safeLoc);
        }
        catch (Exception e) {
            TeleportUtils.handleException(e);
            return false;
        }
    }

    public static boolean teleportToLastLocation(class_3222 player) {
        try {
            if (!PlayerLocationTracker.hasPreviousLocation(player)) {
                LOGGER.debug("Failed to teleport {} to last location: no previous location found", (Object)player.method_5477().toString());
                return false;
            }
            PlayerLocationTracker.PlayerLocation location = PlayerLocationTracker.getPreviousLocation(player);
            class_3218 world = player.method_51469();
            class_2338 pos = location.getBlockPos();
            LOGGER.debug("Attempt to teleport {} back to ({}, {}, {})", new Object[]{player.method_5477().toString(), pos.method_10263(), pos.method_10264(), pos.method_10260()});
            class_3218 targetWorld = TeleportUtils.getTargetWorld(player, location.getWorldId());
            if (targetWorld == null) {
                LOGGER.warn("Failed to find world {} for previous location warp", (Object)location.getWorldId());
                player.method_7353((class_2561)class_2561.method_43470((String)"Failed to teleport: warp world not found"), false);
                return false;
            }
            class_2338 safeLoc = TeleportUtils.findSafeLocation((class_1937)targetWorld, pos);
            return TeleportUtils.teleportPlayer(player, (class_1937)targetWorld, safeLoc);
        }
        catch (Exception e) {
            TeleportUtils.handleException(e);
            return false;
        }
    }

    public static boolean teleportToWarp(class_3222 player, class_1937 world, String warpName, DatabaseManager dbManager) {
        try {
            WarpPosition warp = dbManager.getWarp(warpName);
            if (warp == null) {
                LOGGER.warn("Failed to find warp for player {}: {}", (Object)player.method_5477().toString(), (Object)warpName);
                return false;
            }
            if (warp.isPrivate() && !warp.getPlayerUUID().equals(player.method_5667())) {
                LOGGER.warn("Failed to teleport {} to warp {}: warp is private and not owned by player", (Object)player.method_5477().toString(), (Object)warpName);
                player.method_7353((class_2561)class_2561.method_43470((String)"Teleportation failed. Warp is private and not owned by you."), false);
                return false;
            }
            class_2338 warpPos = warp.getBlockPos();
            LOGGER.debug("Attempting to teleport {} to ({}, {}, {})", new Object[]{player.method_5477().toString(), warpPos.method_10263(), warpPos.method_10264(), warpPos.method_10260()});
            class_3218 targetWorld = TeleportUtils.getTargetWorld(player, warp.getWorldId());
            if (targetWorld == null) {
                LOGGER.warn("Failed to find world {} for warp {}", (Object)warp.getWorldId(), (Object)warpName);
                player.method_7353((class_2561)class_2561.method_43470((String)"Failed to teleport: warp world not found"), false);
                return false;
            }
            class_2338 safeLoc = TeleportUtils.findSafeLocation((class_1937)targetWorld, warpPos);
            return TeleportUtils.teleportPlayer(player, (class_1937)targetWorld, safeLoc);
        }
        catch (Exception e) {
            TeleportUtils.handleException(e);
            return false;
        }
    }

    public static class_2338 findSafeLocation(class_1937 world, class_2338 spawnPos) throws NoSafeLocationFoundException {
        if (TeleportUtils.isSafeLocation(world, spawnPos)) {
            return spawnPos;
        }
        int searchRadius = 10;
        for (int dx = -searchRadius; dx <= searchRadius; ++dx) {
            for (int dy = -searchRadius; dy <= searchRadius; ++dy) {
                for (int dz = -searchRadius; dz <= searchRadius; ++dz) {
                    class_2338 pos = spawnPos.method_10069(dx, dy, dz);
                    if (!TeleportUtils.isSafeLocation(world, pos)) continue;
                    LOGGER.debug("Found safe location at offset ({}, {}, {}) from spawn", new Object[]{dx, dy, dz});
                    return pos;
                }
            }
        }
        LOGGER.warn("Failed to find safe location within search radius of ({}, {}, {})", new Object[]{spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260()});
        throw new NoSafeLocationFoundException("Failed to find safe location");
    }

    private static boolean isSafeLocation(class_1937 world, class_2338 pos) {
        boolean hasSafeBase;
        class_2338 belowPos = pos.method_10074();
        class_2338 headPos = pos.method_10084();
        class_2680 headState = world.method_8320(headPos);
        class_2680 feetState = world.method_8320(pos);
        class_2680 belowState = world.method_8320(belowPos);
        boolean bl = hasSafeBase = belowState.method_26212((class_1922)world, belowPos) || belowState.method_27852(class_2246.field_10382);
        if (!hasSafeBase) {
            return false;
        }
        boolean isHeadSafe = TeleportUtils.isSafeToStandIn(headState, world, headPos);
        boolean isFeetSafe = TeleportUtils.isSafeToStandIn(feetState, world, pos);
        return isHeadSafe && isFeetSafe;
    }

    private static boolean isSafeToStandIn(class_2680 state, class_1937 world, class_2338 pos) {
        if (state.method_26215()) {
            return true;
        }
        if (state.method_27852(class_2246.field_10382)) {
            return true;
        }
        if (!state.method_26212((class_1922)world, pos)) {
            return true;
        }
        if (state.method_27852(class_2246.field_10164)) {
            return false;
        }
        if (state.method_27852(class_2246.field_10036) || state.method_27852(class_2246.field_22089)) {
            return false;
        }
        return false;
    }

    private static boolean teleportPlayer(class_3222 player, class_1937 targetWorld, class_2338 pos) {
        boolean teleported;
        PlayerLocationTracker.storeCurrentLocation(player);
        double x = (double)pos.method_10263() + 0.5;
        double y = pos.method_10264();
        double z = (double)pos.method_10260() + 0.5;
        class_3218 currentWorld = player.method_51469();
        class_3218 targetServerWorld = (class_3218)targetWorld;
        class_243 currentPos = player.method_73189();
        TeleportUtils.spawnTeleportEffects(currentWorld, currentPos, true);
        if (currentWorld.method_27983() != targetWorld.method_27983()) {
            LOGGER.debug("Cross-dimension teleport from {} to {} for player {}", new Object[]{currentWorld.method_27983().method_29177(), targetWorld.method_27983().method_29177(), player.method_5477().toString()});
            class_5454 target = new class_5454(targetServerWorld, new class_243(x, y, z), class_243.field_1353, player.method_36454(), player.method_36455(), class_5454.field_52245);
            class_3222 result = player.method_61275(target);
            teleported = result != null;
        } else {
            teleported = player.method_6082(x, y, z, false);
        }
        LOGGER.debug("Teleport attempt was {} for player {} at ({}, {}, {})", new Object[]{teleported, player.method_5477().toString(), x, y, z});
        if (!teleported) {
            LOGGER.warn("failed to teleport {} to spawn at ({}, {}, {})", new Object[]{player.method_5477().toString(), x, y, z});
        }
        if (teleported) {
            TeleportUtils.spawnTeleportEffects(targetServerWorld, new class_243(x, y, z), false);
        }
        return teleported;
    }

    private static void handleException(Exception e) {
        if (e instanceof NoSafeLocationFoundException) {
            NoSafeLocationFoundException nslfe = (NoSafeLocationFoundException)e;
            LOGGER.error("Failed to find safe location: {}", (Object)nslfe.getMessage());
        } else {
            LOGGER.error("Unexpected error during teleport: {}", (Object)e.getMessage());
        }
    }

    private static void spawnTeleportEffects(class_3218 world, class_243 pos, boolean isDeparture) {
        if (isDeparture) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            for (i = 0; i < 50; ++i) {
                offsetX = (Math.random() - 0.5) * 1.5;
                offsetY = Math.random() * 2.0;
                offsetZ = (Math.random() - 0.5) * 1.5;
                world.method_65096((class_2394)class_2398.field_11214, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 1, 0.2, 0.5, 0.2, 0.1);
            }
            for (i = 0; i < 20; ++i) {
                offsetX = Math.random() - 0.5;
                offsetY = Math.random() * 2.0;
                offsetZ = Math.random() - 0.5;
                world.method_65096((class_2394)class_2398.field_22246, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
            world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14890, class_3419.field_15248, 1.0f, 1.0f);
        } else {
            for (int i = 0; i < 50; ++i) {
                double offsetX = (Math.random() - 0.5) * 1.5;
                double offsetY = Math.random() * 2.0;
                double offsetZ = (Math.random() - 0.5) * 1.5;
                world.method_65096((class_2394)class_2398.field_22246, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 1, 0.2, 0.5, 0.2, 0.1);
            }
            world.method_65096((class_2394)class_2398.field_11203, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 30, 0.5, 0.5, 0.5, 0.05);
            world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14890, class_3419.field_15248, 1.0f, 1.2f);
        }
    }

    private static class_3218 getTargetWorld(class_3222 player, String targetWorldId) {
        MinecraftServer server = player.method_64396().method_9211();
        if (server == null) {
            LOGGER.error("Server is null for player {}", (Object)player.method_5477().toString());
            return null;
        }
        class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)targetWorldId));
        class_3218 targetWorld = server.method_3847(worldKey);
        return targetWorld;
    }
}

