/*
 * Decompiled with CFR 0.152.
 */
package uk.co.finleyofthewoods.warpspeed;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.finleyofthewoods.warpspeed.command.BackCommand;
import uk.co.finleyofthewoods.warpspeed.command.HomeCommand;
import uk.co.finleyofthewoods.warpspeed.command.SpawnCommand;
import uk.co.finleyofthewoods.warpspeed.command.WarpCommand;
import uk.co.finleyofthewoods.warpspeed.utils.DatabaseManager;

public class Warpspeed
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger(Warpspeed.class);
    private static DatabaseManager dbManager;

    public void onInitialize() {
        LOGGER.info("Initialising Warpspeed mod");
        dbManager = new DatabaseManager();
        dbManager.initialise();
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            LOGGER.info("Closing database...");
            dbManager.close();
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            SpawnCommand.register((CommandDispatcher<class_2168>)dispatcher);
            HomeCommand.register((CommandDispatcher<class_2168>)dispatcher, dbManager);
            BackCommand.register((CommandDispatcher<class_2168>)dispatcher);
            WarpCommand.register((CommandDispatcher<class_2168>)dispatcher, dbManager);
        });
    }

    public static DatabaseManager getDatabaseManager() {
        if (dbManager == null) {
            LOGGER.warn("Database manager accessed before initialization, creating new instance");
            dbManager = new DatabaseManager();
            dbManager.initialise();
        }
        return dbManager;
    }
}

