/*
 * Decompiled with CFR 0.152.
 */
package uk.co.finleyofthewoods.warpspeed.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.finleyofthewoods.warpspeed.utils.TeleportUtils;

public class SpawnCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpawnCommand.class);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").requires(source -> source.method_44023() != null)).executes(SpawnCommand::execute));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            LOGGER.warn("Command executed by null player");
            return 0;
        }
        try {
            class_3218 overworld = source.method_9211().method_3847(class_1937.field_25179);
            assert (overworld != null);
            class_2338 spawnPos = overworld.method_74854().method_74897();
            LOGGER.debug("Player {} executed /spawn command. Teleporting to spawn at {} {} {}", new Object[]{player.method_5477().getString(), spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260()});
            boolean success = TeleportUtils.teleportToSpawn(player, (class_1937)overworld, spawnPos);
            if (success) {
                LOGGER.debug("Successfully teleported player {}", (Object)player.method_5477().getString());
                player.method_7353((class_2561)class_2561.method_43470((String)"Teleported to spawn!"), false);
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"Failed to teleport to spawn!"), false);
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("Failed to execute /spawn command", (Throwable)e);
            player.method_7353((class_2561)class_2561.method_43470((String)"Failed to teleport to spawn!"), false);
            return 0;
        }
    }
}

